/*
 * $Id: OpenLogAction.java 72790 2008-02-15 20:05:47Z clinio $
 */
package csbase.client.applications.csvviewer.actions;

import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.csvviewer.CSVViewer;
import csbase.logic.ClientFile;

/**
 * Pede para a aplicao que detm o painel de controle por um novo arquivo de
 * csv e o abre no painel de csv.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class SaveCSVAction extends AbstractCSVAction {

  /**
   * Construtor
   * 
   * @param application o aplicativo dono dessa ao.
   */
  public SaveCSVAction(CSVViewer application) {
    super(application, ApplicationImages.ICON_SAVE_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone(JComponent component) {
    CSVViewer application = getApplication();
    ClientFile file = application.getFile();
    application.saveFile(file);
  }

}
