/*
 * $Id$
 */
package csbase.client.applications.fileexchanger;

import tecgraf.javautils.core.lng.FormatUtils;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Utilitrio de interface grfica
 * 
 * @author Tecgraf/PUC-Rio
 */
public class FileExchangerUI {

  /**
   * Separador de tags.
   */
  final private static String TAG_SEPARATOR = ".";

  /**
   * Identificador do aplicativo.
   */
  final private static String ID = "fileexchanger";

  /**
   * Busca de um texto de internacionalizao do programa sem sua referncia
   * 
   * @param theClass a classe de prefixo.
   * @param tag o tag
   * @return o texto buscado direto o <i>application manager</i>
   */
  final public static String getClassString(final Class<?> theClass,
    final String tag) {
    final String classPrefix = theClass.getSimpleName();
    final String theTag = classPrefix + TAG_SEPARATOR + tag;
    final ApplicationManager mgr = ApplicationManager.getInstance();
    final ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
    return reg.getString(theTag);
  }

  /**
   * Busca de um texto de internacionalizao do programa sem sua referncia
   * 
   * @param tag o tag
   * @return o texto buscado direto o <i>application manager</i>
   */
  final public static String getString(final String tag) {
    final ApplicationManager mgr = ApplicationManager.getInstance();
    final ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
    return reg.getString(tag);
  }

  /**
   * Busca de um texto de internacionalizao do programa sem sua referncia
   * 
   * @param theClass a classe de prefixo.
   * @param tag o tag
   * @param objs objetos de formatao
   * @return o texto buscado direto o <i>application manager</i>
   */
  final public static String getClassString(final Class<?> theClass,
    final String tag, final Object[] objs) {
    final String classPrefix = theClass.getSimpleName();
    final String theTag = classPrefix + TAG_SEPARATOR + tag;
    final ApplicationManager mgr = ApplicationManager.getInstance();
    final ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
    return reg.getString(theTag, objs);
  }

  /**
   * Busca de um texto de internacionalizao do programa sem sua referncia
   * 
   * @param tag o tag
   * @param objs objetos de formatao
   * @return o texto buscado direto o <i>application manager</i>
   */
  final public static String getString(final String tag, final Object... objs) {
    final ApplicationManager mgr = ApplicationManager.getInstance();
    final ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
    return reg.getString(tag, objs);
  }

  /**
   * Busca de um texto de internacionalizao do programa sem sua referncia
   * 
   * @param theClass a classe de prefixo.
   * @param tag o tag
   * @return o texto buscado direto o <i>application manager</i>
   */
  final public static boolean hasClassString(final Class<?> theClass,
    final String tag) {
    final String classPrefix = theClass.getSimpleName();
    final String theTag = classPrefix + TAG_SEPARATOR + tag;
    final ApplicationManager mgr = ApplicationManager.getInstance();
    final ApplicationRegistry reg = mgr.getApplicationRegistry(ID);
    return reg.hasString(theTag);
  }

  /**
   * Teste se uma string  nula.
   * 
   * @param str a string a ser testada
   * @return um indicativo booleano
   */
  public static boolean isEmptyString(final String str) {
    if (str == null) {
      return true;
    }
    final String s = str.trim();
    if (s.equals("")) {
      return true;
    }
    return false;
  }

  /**
   * Formata intervalo de tempo em ms.
   * 
   * @param value o valor em ms.
   * @return o texto
   */
  public static String formatLongTime(final long value) {
    if (value < 0) {
      return "-";
    }
    final int sec = (int) Math.round(value / 1000.);
    return FormatUtils.formatInterval(sec);
  }

  /**
   * Tratador de excees
   * 
   * @param fileExchanger aplicao
   * @param e exceo
   */
  public static void handleException(final FileExchanger fileExchanger,
    final Exception e) {
    fileExchanger.showException(fileExchanger.getName(), e);
  }

}
