package csbase.client.applications.flowapplication.actions;

import java.awt.event.ActionEvent;

import csbase.client.algorithms.tasks.CreateFlowConfiguratorTask;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphFileDescriptor;
import csbase.client.applications.flowapplication.graph.GraphLink;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;

/**
 * Ao que executa o fluxo de algoritmos corrente.
 */
public final class ExecuteGraphAction extends FlowApplicationAction {
  /**
   * Cria a ao.
   *
   * @param application A aplicao construtura de fluxos.
   */
  public ExecuteGraphAction(FlowApplication application) {
    super(application, ApplicationImages.ICON_PLAY_16);
    setEnabled(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleActionPerformed(ActionEvent e) {
    FlowApplication application = getApplication();
    Workspace workspace = application.getWorkspace();
    Graph graph = workspace.getGraph();
    if (!graph.isExecutable()) {
      throw new IllegalStateException(
        "O fluxo de algoritmos no est pronto para ser executado.");
    }
    /* Se for obrigatrio, salva antes de continuar */
    if (application.hasToSaveBeforeExecute()) {
      if (!application.saveGraph()) {
        application.showInformation(application
          .getString("msg.change.preference.to.execute.flow"));
        return;
      }
    }
    Flow flow = graph.toFlow();
    flow.setName(application.getFlowName());
    flow.setDescription(application.getFlowDescription());
    FlowAlgorithmConfigurator configurator =
      CreateFlowConfiguratorTask.runTask(application.getApplicationFrame(),
        flow);
    if (configurator != null) {
      application.executeFlow(configurator);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasChangedWorkspace(Graph graph) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementCreated(Graph graph, GraphElement element) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementParametrized(Graph graph, GraphElement element) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementRemoved(Graph graph, GraphElement element) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasLinkAnchored(Graph graph, GraphLink link,
    GraphFileDescriptor fileDescriptor) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasLinkIncreased(Graph graph, GraphLink link) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasLinkStatusChanged(Graph graph, GraphLink link) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasLinkUnanchored(Graph graph, GraphLink link,
    GraphFileDescriptor fileDescriptor) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasParameterSetEnabled(Graph graph, GraphNode node,
    String parameterName, boolean isEnabled) {
    updateEnabledStatus(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasParameterSetVisible(Graph graph, GraphNode node,
    String parameterName, boolean isVisible) {
    updateEnabledStatus(graph);
  }

  /**
   * Habilita/desabilita a ao, dependendo do estado do grafo.
   *
   * @param graph O grafo.
   */
  private void updateEnabledStatus(Graph graph) {
    setEnabled(graph.isExecutable());
  }
}
