package csbase.client.applications.flowapplication.messages;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import tecgraf.vix.Message;
import csbase.client.applications.flowapplication.graph.GraphElement;

public final class SelectElementsMessage extends Message {
  private final List<GraphElement> elements;

  public SelectElementsMessage(final Collection<GraphElement> elements) {
    if (elements == null) {
      throw new IllegalArgumentException("O parmetro elements est nulo.");
    }
    this.elements = new LinkedList<GraphElement>(elements);
  }

  public Collection<GraphElement> getElements() {
    return Collections.unmodifiableList(this.elements);
  }
}
