package csbase.client.applications.jobmonitor.columns;

import csbase.client.applications.jobmonitor.rowmodel.JobInfoRow;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;

/**
 * Coluna que exibe valores do tipo String.
 * 
 * @author Tecgraf
 */
public class StringJobInfoColumn extends AbstractConfigurableColumn<JobInfoRow> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   */
  public StringJobInfoColumn(String id) {
    super(id, true, null, null);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return String.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getId();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(JobInfoRow obj) {
    return obj.get(getId());
  }

}
