/*
 * $Id$
 */

package csbase.client.applications.projectsmanager.actions;

import java.util.List;

import javax.swing.ImageIcon;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.actions.core.ProjectsManagerAction;
import csbase.client.applications.projectsmanager.dialogs.ChangeServerOwnerProjectDialog;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;

/**
 * Ao que abre o dilogo para alterao do nome do servidor dono dos projetos.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ChangeServerOwnerProjectDialogAction extends ProjectsManagerAction {

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public ChangeServerOwnerProjectDialogAction(
    final ProjectsManager projectsManager) {
    super(projectsManager);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionDone() throws Exception {
    ProjectsManager projectsManager = getProjectsManager();
    List<ProjectsManagerData> projectList =
      projectsManager.getSelectedProjects();
    if (projectList == null || projectList.size() == 0) {
      return;
    }

    final ChangeServerOwnerProjectDialog dialog =
      new ChangeServerOwnerProjectDialog(projectsManager, projectList);

    dialog.pack();
    //    dialog.center();
    dialog.setVisible(true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ImageIcon getStandardImageIcon() {
    return ApplicationImages.ICON_EDIT_16;
  }

}
