package csbase.client.applications.projectsmanager.panels.renderers;

import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingConstants;

import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;

/**
 * Renderer para a lista de projetos.
 * 
 * @author jnlopes
 * 
 */
public class ProjectListCellRenderer implements ListCellRenderer {

  /**
   * boolean que indica se o nome do dono do projeto deve aparecer.
   */
  final private boolean displayOwner;

  /**
   * Construtor
   * 
   * @param displayOwner boolean que indica se o nome do dono do projeto deve
   *        aparecer.
   */
  public ProjectListCellRenderer(final boolean displayOwner) {
    this.displayOwner = displayOwner;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getListCellRendererComponent(JList list, Object value,
    int index, boolean isSelected, boolean cellHasFocus) {

    if (value == null) {
      return null;
    }

    final ProjectsManagerData pmd = (ProjectsManagerData) value;

    StringBuilder content = new StringBuilder(pmd.getProjectName());
    if (displayOwner) {
      content.append(" (" + pmd.getOwnerId() + ")");
    }

    final JLabel label = new JLabel(content.toString());
    label.setHorizontalAlignment(SwingConstants.LEFT);
    final ProjectsManagerScope scope = pmd.getScope();
    if (scope != null) {
      label.setIcon(scope.getIcon());
    }

    return label;
  }
}
