package csbase.client.applications.projectsmanager.proxy.core;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.desktop.RemoteTask;

/**
 * RemoteTask genrica a ser estendida por classes especficas da aplicao
 * ProjectsManager.
 * 
 * @author jnlopes
 * 
 * @param <R> o tipo resultado.
 */
public abstract class ProjectsManagerTask<R> extends RemoteTask<R> {

  /**
   * A aplicao.
   */
  private final ProjectsManager projectsManager;

  /**
   * Construtor
   * 
   * @param projectsManager a aplicao.
   */
  public ProjectsManagerTask(final ProjectsManager projectsManager) {
    this.projectsManager = projectsManager;
  }

  /**
   * Consulta a aplicao
   * 
   * @return a aplicao
   */
  public ProjectsManager getProjectsManager() {
    return projectsManager;
  }

  /**
   * Mtodo de busca de uma string de internacionalizao dentro do escopo da
   * ao conforme o padro "<code>NomeDaClasse.TagDesejada</code>"
   * 
   * @param tag tag desejada
   * @return o texto de internacionalizao
   * @see ProjectsManagerTask#getClassString(String)
   */
  final public String getClassString(final String tag) {
    return ProjectsManagerUI.getClassString(getClass(), tag);
  }

  /**
   * Mtodo de busca de uma string de internacionalizao dentro do escopo da
   * ao.
   * 
   * @param tag tag desejada
   * @return o texto de internacionalizao
   * @see ProjectsManagerTask#getString(String)
   */
  final public String getString(final String tag) {
    return ProjectsManagerUI.getString(tag);
  }

  /**
   * Exibio de mensagem de erro.
   * 
   * @param msg a mensagem.
   */
  final public void showError(String msg) {
    projectsManager.showError(projectsManager.getApplicationFrame(), msg);
  }

}
