package csbase.client.csdk.v2.command;

import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationInfo.FinalizationInfoType;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandNotification;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.logic.ExtendedCommandFinishedNotification;
import csdk.v2.api.command.ICommandInfo;

/**
 * Encapsula um evento de comando do sistema em um evento do CSDK.
 */
public class CSDKCommandInfo implements ICommandInfo {

  /**
   * Notificao encapsulada.
   */
  private final CommandNotification data;

  /**
   * Construtor.
   * 
   * @param data a notificao a ser encapsulada.
   */
  public CSDKCommandInfo(CommandNotification data) {
    this.data = data;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getCommandId() {
    return data.getCommandId().toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public FinalizationType getFinalizationType() {
    CommandFinalizationInfo finalizationInfo = data.getFinalizationInfo();
    CommandFinalizationType type = finalizationInfo.getFinalizationType();
    switch (type) {
      case END:
        return FinalizationType.COMPLETED;
      case EXECUTION_ERROR:
        return FinalizationType.ERROR;
      case FAILED:
        return FinalizationType.INIT_FAILURE;
      case KILLED:
        return FinalizationType.KILLED;
      case LOST:
        return FinalizationType.LOST;
      case NO_EXIT_CODE:
        return FinalizationType.NO_CODE;
      case SUCCESS:
        return FinalizationType.SUCCESS;
      default:
        throw new IllegalArgumentException("Tipo do evento invlido: " + type);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getExecutionHost() {
    Object execHost = data.getExecHost();
    if (execHost != null) {
      return execHost.toString();
    }
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getDescription() {
    return data.getCmdDesc();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Integer getExitCode() {
    CommandFinalizationInfo finalizationInfo = data.getFinalizationInfo();
    return finalizationInfo.getExitCode();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getProjectId() {
    return data.getProjectId().toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Long getStartTime() {
    return data.getStartTime();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Integer getGuiltyNodeId() {
    CommandFinalizationInfo finalizationInfo = data.getFinalizationInfo();
    FinalizationInfoType infoType = finalizationInfo.getInfoType();
    if (infoType.equals(FinalizationInfoType.EXTENDED)) {
      ExtendedCommandFinalizationInfo extendedInfo =
        (ExtendedCommandFinalizationInfo) finalizationInfo;
      return extendedInfo.getGuiltyNodeId();
    }
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Integer getCPUTimeSec() {
    if (data instanceof ExtendedCommandFinishedNotification) {
      ExtendedCommandFinishedNotification timedData =
        (ExtendedCommandFinishedNotification) data;
      return timedData.getCPUTime();
    }
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Integer getElapsedTimeSec() {
    if (data instanceof ExtendedCommandFinishedNotification) {
      ExtendedCommandFinishedNotification timedData =
        (ExtendedCommandFinishedNotification) data;
      return timedData.getElapsedTime();
    }
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Long getEndTime() {
    if (data instanceof ExtendedCommandFinishedNotification) {
      ExtendedCommandFinishedNotification timedData =
        (ExtendedCommandFinishedNotification) data;
      return timedData.getEndTime();
    }
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Integer getUserTimeSec() {
    if (data instanceof ExtendedCommandFinishedNotification) {
      ExtendedCommandFinishedNotification timedData =
        (ExtendedCommandFinishedNotification) data;
      return timedData.getUserTime();
    }
    return null;
  }

}
