package csbase.client.facilities.algorithms.executor;

import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.logic.CommandNotification;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;

/**
 * Encapsula os observadores de comando.
 */
final class CommandRemoteListener implements IMessageListener {

  /**
   * Lista de observadores a serem encapsulados.
   */
  private final CommandObserver[] observers;

  /**
   * Identificador do comando.
   */
  private final String cmdId;

  /**
   * Construtor.
   * 
   * @param cmdId Identificador do comando.
   * @param observers lista de observadores a serem encapsulados.
   */
  public CommandRemoteListener(String cmdId, CommandObserver[] observers) {
    this.cmdId = cmdId;
    this.observers = observers;
  }

  /**
   * Construtor.
   * 
   * @param cmdId Identificador do comando.
   * @param observer observador a ser encapsulado.
   */
  public CommandRemoteListener(String cmdId, CommandObserver observer) {
    this(cmdId, new CommandObserver[] { observer });
  }

  /**
   * Determina se a notificao indica  de interesse do observador.
   * 
   * @param data a notificao.
   * @return verdadeiro se a notificao  de interesse ou falso, caso
   *         contrrio.
   */
  private boolean isInterested(CommandNotification data) {
    return cmdId.equals(data.getCommandId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void onMessagesReceived(Message... messages) throws Exception {
    for (Message message : messages) {
      CommandNotification body = (CommandNotification) message.getBody();
      if (!isInterested(body)) {
        return;
      }
      for (CommandObserver commandObserver : observers) {
        commandObserver.notify(body);
      }
    }
    MessageProxy.removeListener(this);
  }
}
