package csbase.client.preferences.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferenceDefinition;

/**
 * Anotao que define qual classe que encapsula o valor de uma preferncia e
 * qual o seu valor default.
 * 
 * @see PreferenceDefinition PreferenceValue
 * 
 * @author Tecgraf
 */
@Documented
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface Value {

  /**
   * Classe que encapsula o valor da preferncia.
   * 
   * @return classe que encapsula o valor da preferncia.
   */
  Class<? extends PreferenceValue<?>> type();

  /**
   * Valor default da preferncia.
   * 
   * @return valor default da preferncia.
   */
  String defaultValue();
}
