/*
 * $Id$
 */
package csbase.client.project.action;

import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTree;
import csbase.client.project.dialogs.PublishProjectDialog;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectPermissions.SharingType;
import csbase.logic.User;
import csbase.logic.UserOutline;

/**
 * Ao que gerencia os usurios de um projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectUsersManagementAction extends ProjectAction {
  /**
   * Executa a ao.
   * 
   * @param e .
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    RemoteTask<List<UserOutline>> task = new RemoteTask<List<UserOutline>>() {
      @Override
      protected final void performTask() throws Exception {
        this.setResult(User.getAllOutlines());
      }

      /**
       * {@inheritDoc}
       */
      @Override
      protected final void handleError(Exception exception) {
        if (exception instanceof RemoteException) {
          super.handleError(exception);
        }
        else {
          StandardErrorDialogs.showErrorDialog(this.parentWindow,
            this.taskTitle, exception);
        }
      }
    };
    if (task.execute(this.getWindow(), this.getName(),
      MessageFormat.format(LNG.get("PRJ_WAITING_USERS_FROM_PRJ"), this
        .getCurrentProject().getName()))) {
      List<UserOutline> allUsers = task.getResult();
      CommonClientProject currentProject = getCurrentProject();
      PublishProjectDialog dialog =
        new PublishProjectDialog(DesktopFrame.getInstance().getDesktopFrame(),
          currentProject, allUsers, currentProject.getUsersRO(),
          currentProject.getUsersRW());
      if (dialog.execute()) {
        updateProject(dialog.getSharingType(), dialog.getUsersRO(),
          dialog.getUsersRW());
      }
    }
  }

  /**
   * Atualiza os usurios que possuem acesso ao projeto.
   * 
   * @param sharingType - tipo do compartilhamento
   * @param usersRO - usurios com acesso RO ao projeto
   * @param usersRW - usurios com acesso RW ao projeto
   */
  private void updateProject(final SharingType sharingType,
    final Set<Object> usersRO, final Set<Object> usersRW) {
    final CommonClientProject project = getCurrentProject();
    RemoteTask<Void> task = new RemoteTask<Void>() {
      @Override
      public void performTask() throws Exception {
        project.updateUsers(sharingType, usersRO, usersRW);
      }
    };
    /* Executa a tarefa no servidor */
    if (!task.execute(getWindow(), getName(), MessageFormat.format(
      LNG.get("PRJ_WAITING_USERS_MNG"), new Object[] { project.getName() }))) {
      StandardErrorDialogs.showErrorDialog(getWindow(), getName(),
        MessageFormat.format(LNG.get("PRJ_PROJECT_USERS_MNG_ERROR"),
          new Object[] { project.getName() }));
    }
  }

  /**
   * Obtm o nome da ao.
   * 
   * @return .
   */
  @Override
  public String getName() {
    return LNG.get("PRJ_PROJECT_USERS_MNG_TITLE");
  }

  /**
   * Constri a ao.
   * 
   * @param treeView .
   */
  public ProjectUsersManagementAction(ProjectTree treeView) {
    super(treeView);
  }
}
