package csbase.client.rest;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

/**
 * Classe para debugar problemas em modo desevolvedor
 * 
 * @author Tecgraf/PUC-Rio
 */
@Provider
public class DebugMapper implements ExceptionMapper<Throwable> {

  /**
   * {@inheritDoc}
   */
  @Override
  public Response toResponse(Throwable exception) {
    exception.printStackTrace();
    if (exception instanceof WebApplicationException) {
      return ((WebApplicationException) exception).getResponse();
    }
    return Response.serverError().entity(exception.getMessage()).build();
  }
}