/*
 * Detalhes da ltima alterao:
 *
 * $Author$
 * $Date$
 * $Revision$
 */
package csbase.client.util;

import java.util.Observable;
import java.util.Observer;

import tecgraf.javautils.gui.SwingThreadDispatcher;

/**
 * <p>Um wrapper que permite usar um SwingObserver como se fosse um {@link
 * java.util.Observer}</p>
 *
 * @author Tecgraf/PUC-Rio
 */
public final class SwingObserverWrapper implements Observer {
  /** O SwingObserver que ser representado pelo wrapper. */
  private SwingObserver observer;

/**
 * Cria um wrapper.
 * 
 * @param observer O objeto que ser representado pelo wrapper.
 */
  public SwingObserverWrapper(SwingObserver observer) {
    this.observer = observer;
  }

  public void update(Observable observable, Object arg) {
    SwingThreadDispatcher.invokeLater(
      new ObserverRunnable(this.observer, observable, arg));
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }
    if (!obj.getClass().equals(SwingObserverWrapper.class)) {
      return false;
    }
    SwingObserverWrapper wrapper = (SwingObserverWrapper)obj;
    return wrapper.observer.equals(this.observer);
  }

  @Override
  public int hashCode() {
    return this.observer.hashCode();
  }

  /**
   * Classe auxiliar que executar o mtodo doUpdate de um objeto do tipo
   * {@link SwingObserver} em uma thread.
   *
   * @author Tecgraf/PUC-Rio
   */
  private static class ObserverRunnable implements Runnable {
    /** O objeto que ter o mtodo doUpdate chamado. */
    private SwingObserver observer;

    /** O observvel que gerou o evento. */
    private Observable observable;

    /** O argumento do evento. */
    private Object arg;

/**
    *  Cria um objeto para executar o mtodo doUpdate do observador especificado. 
    *  
    * @param observer O observador.
    * @param observable O observvel que gerou o evento.
    * @param arg O argumento do evento.
    */
    public ObserverRunnable(
      SwingObserver observer, Observable observable, Object arg) {
      this.observer = observer;
      this.observable = observable;
      this.arg = arg;
    }

    public void run() {
      this.observer.doUpdate(this.observable, this.arg);
    }
  }
}
