package csbase.client.util.xmlpanel.xmltagtreepanel;

import java.util.List;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

import org.w3c.dom.Node;

import csbase.client.util.xmlpanel.XMLPanelUtils;

/**
 * Modelo bsico.
 * 
 * @author Tecgraf/PUC-Rio
 */
class XMLTagTreeModel implements TreeModel {
  /**
   * N do modelo.
   */
  final private Node node;

  /**
   * {@inheritDoc}
   */
  @Override
  public void addTreeModelListener(TreeModelListener listener) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getChild(Object parent, int index) {
    final Node parentNode = (Node) parent;
    final List<Node> children = XMLPanelUtils.getElementChildren(parentNode);
    final Node child = children.get(index);
    return child;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getChildCount(Object parent) {
    final Node parentNode = (Node) parent;
    final List<Node> children = XMLPanelUtils.getElementChildren(parentNode);
    if (children == null) {
      return 0;
    }
    return children.size();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getIndexOfChild(Object parent, Object child) {
    final Node parentNode = (Node) parent;
    final List<Node> children = XMLPanelUtils.getElementChildren(parentNode);
    if (children == null) {
      return 0;
    }
    return children.indexOf(child);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getRoot() {
    return node;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isLeaf(Object object) {
    final Node objectNode = (Node) object;
    final List<Node> children = XMLPanelUtils.getElementChildren(objectNode);
    return (children == null || children.size() == 0);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void removeTreeModelListener(TreeModelListener listener) {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void valueForPathChanged(TreePath path, Object newValue) {
  }

  /**
   * Construtor
   * 
   * @param node n.
   */
  public XMLTagTreeModel(Node node) {
    this.node = node;
  }
}