/*
 * $Id:$
 */

package csbase.client.util.xmlpanel.xmltagtreepanel;

import java.awt.Component;

import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;

import org.w3c.dom.Node;

import csbase.client.util.xmlpanel.XMLPanelStyleInterface;

/**
 * Renderer.
 * 
 * @author Tecgraf/PUC-Rio
 */
class XMLTagTreeRenderer extends DefaultTreeCellRenderer {

  /**
   * Definidor de imagens de elementos.
   */
  private XMLPanelStyleInterface style;

  /**
   * {@inheritDoc}
   */
  @Override
  public Component getTreeCellRendererComponent(JTree tree, Object value,
    boolean sel, boolean expanded, boolean leaf, int row, boolean isWithFocus) {
    final Node node = (Node) value;
    final String textValue = node.getNodeName();
    super.getTreeCellRendererComponent(tree, textValue, sel, expanded, leaf,
      row, isWithFocus);

    Node parentNode = node.getParentNode();
    TreeModel model = tree.getModel();
    int index = -1;
    if (parentNode != null) {
      index = model.getIndexOfChild(parentNode, node) + 1;
    }

    if (style == null) {
      setText(textValue);
    }
    else {
      setIcon(style.getIcon(node, textValue, index));
      setText(style.getTreeText(node, textValue, index));
      setToolTipText(textValue);
    }
    return this;
  }

  /**
   * Ajusta o valor: defindor de estilo ({@link #style} )
   * 
   * @param style o definidor
   */
  void setStyle(XMLPanelStyleInterface style) {
    this.style = style;
  }

  /**
   * Retorna: defindor de estilo; conforme atributo {@link #style}.
   * 
   * @return o definidor
   */
  XMLPanelStyleInterface getStyle() {
    return style;
  }

  /**
   * Construtor
   */
  XMLTagTreeRenderer() {
    this.style = null;
    setOpenIcon(null);
    setClosedIcon(null);
    setLeafIcon(null);
  }
}