/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.cache.events;

import csbase.client.util.event.IEvent;
import csbase.logic.CommandInfo;
import java.util.Collection;
import java.util.Collections;

public class CacheUpdatedEvent
implements IEvent {
    private Type type;
    private Exception exception;
    private String exceptionDescription;
    private Collection<CommandInfo> commands;

    public CacheUpdatedEvent(Exception e, String description) {
        this.exception = e;
        this.type = Type.exception;
        this.exceptionDescription = description;
        this.commands = null;
    }

    public CacheUpdatedEvent(Collection<CommandInfo> commands) {
        this.commands = Collections.unmodifiableCollection(commands);
        this.type = Type.updated;
    }

    public Exception getException() {
        return this.exception;
    }

    public String getExceptionDescription() {
        return this.exceptionDescription;
    }

    public Collection<CommandInfo> getCommands() {
        return this.commands;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.commands == null ? 0 : this.commands.hashCode());
        result = 31 * result + (this.exception == null ? 0 : this.exception.getClass().hashCode());
        result = 31 * result + (this.exceptionDescription == null ? 0 : this.exceptionDescription.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheUpdatedEvent other = (CacheUpdatedEvent)obj;
        if (this.commands == null ? other.commands != null : !this.commands.equals(other.commands)) {
            return false;
        }
        if (this.exception == null ? other.exception != null : !this.exception.getClass().equals(other.exception.getClass())) {
            return false;
        }
        if (this.exceptionDescription == null ? other.exceptionDescription != null : !this.exceptionDescription.equals(other.exceptionDescription)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
    }

    public static enum Type {
        exception,
        updated;

    }
}

