/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.actions.CategoryCreateAction;
import csbase.client.applications.algorithmsmanager.actions.CategoryManagementAction;
import csbase.client.applications.algorithmsmanager.actions.CategoryRemoveAction;
import csbase.client.applications.algorithmsmanager.dialogs.CategoryCreateDataPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CategoryEditDataPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CategoryTreeView;
import csbase.client.applications.algorithmsmanager.dialogs.CommonSelectionPanel;
import csbase.client.applications.algorithmsmanager.models.CategoryNodeInterface;
import csbase.client.applications.algorithmsmanager.models.DataInterface;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.tree.FilterableTreePanel;

public class CategorySelectionPanel
extends CommonSelectionPanel {
    private CategoryTreeView categoryTreeView;
    private CategoryCreateAction categoryCreateAction;
    private CategoryRemoveAction categoryRemoveAction;
    private JPanel mainSelectionPanel;
    private FilterableTreePanel dataTreePanel;

    public CategorySelectionPanel(CategoryManagementAction action) {
        super(action);
    }

    @Override
    public CategoryManagementAction getManagementAction() {
        return (CategoryManagementAction)super.getManagementAction();
    }

    @Override
    protected JPanel buildMainSelectionPanel() {
        this.mainSelectionPanel = new JPanel(new GridBagLayout());
        this.dataTreePanel = this.getCategoryTreePanel();
        this.mainSelectionPanel.add((Component)this.dataTreePanel, new GBC(0, 0).both().west().insets(5, 5, 5, 5));
        return this.mainSelectionPanel;
    }

    @Override
    protected List<Action> buildOperationActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        this.categoryCreateAction = new CategoryCreateAction(this, null);
        this.categoryRemoveAction = new CategoryRemoveAction(this, null);
        actions.add(this.categoryCreateAction);
        actions.add(this.categoryRemoveAction);
        return actions;
    }

    @Override
    public List<DataInterface> getSelectedDataList() {
        List<DataInterface> selectedDataList = new ArrayList<DataInterface>();
        if (this.categoryTreeView != null) {
            selectedDataList = this.categoryTreeView.getSelectedDataList();
        }
        return selectedDataList;
    }

    public CategoryNodeInterface getSelectedCategory() {
        return (CategoryNodeInterface)this.getSelectedData();
    }

    @Override
    protected boolean confirmSelectionChanged() {
        boolean confirmed = false;
        if (this.getManagementAction().getEditPanel() != null && this.getManagementAction().getEditPanel().confirmDataChanged()) {
            confirmed = true;
        }
        return confirmed;
    }

    private FilterableTreePanel getCategoryTreePanel() {
        this.categoryTreeView = new CategoryTreeView(this, ((AlgorithmsManager)this.getApplication()).getAllCategories(false));
        FilterableTreePanel dataTreePanel = this.categoryTreeView.getTreePanel();
        return dataTreePanel;
    }

    public CategoryNodeInterface getTreeSelectedCategory() {
        if (this.categoryTreeView != null) {
            return this.categoryTreeView.getFirstSelectedNode();
        }
        return null;
    }

    public void verifyAndChangeButtonsState() {
        boolean enableAddButton = false;
        enableAddButton = this.categoryTreeView.getSelectionCount() <= 1;
        this.categoryCreateAction.setEnabled(enableAddButton);
        boolean enableRemoveButton = false;
        if (!this.categoryTreeView.isRootNodeSelected()) {
            enableRemoveButton = this.categoryTreeView.getSelectionCount() > 0;
        }
        this.categoryRemoveAction.setEnabled(enableRemoveButton);
    }

    public void selectRootNode() {
        this.categoryTreeView.selectRootNode();
    }

    private void selectCategory(Category category) {
        this.categoryTreeView.selectCategory(category);
    }

    public void selectCurrentCategory() {
        this.categoryTreeView.selectCurrentCategory();
    }

    @Override
    protected void handleCategoryCreated(Category category) {
        this.updateSelectionPanel();
        this.selectCategory(category);
    }

    @Override
    protected void handleCategoryRemoved(Category category) {
        this.updateSelectionPanel();
        this.selectCurrentCategory();
    }

    @Override
    protected void handleCategoryUpdated(CategorySet modifiedCategorySet) {
        this.updateSelectionPanel();
        this.selectCurrentCategory();
    }

    private void updateSelectionPanel() {
        this.mainSelectionPanel.remove((Component)this.dataTreePanel);
        this.dataTreePanel = this.updateCategoryTreePanel();
        this.mainSelectionPanel.add((Component)this.dataTreePanel, new GBC(0, 0).both().west().insets(5, 5, 5, 5));
        this.mainSelectionPanel.revalidate();
        ((AlgorithmsManager)this.getApplication()).getApplicationFrame().repaint();
    }

    private FilterableTreePanel updateCategoryTreePanel() {
        this.categoryTreeView.updateCategoryTree(((AlgorithmsManager)this.getApplication()).getAllCategories(false));
        this.dataTreePanel = this.categoryTreeView.getTreePanel();
        return this.dataTreePanel;
    }

    public void initCategoryNodeEdition(CategoryNodeInterface categoryNode) {
        if (categoryNode.isRootNode()) {
            this.getManagementAction().updateEditPanel(false);
        } else {
            this.getManagementAction().updateEditPanel(true);
            ((CategoryEditDataPanel)this.getManagementAction().getEditPanel()).changeUpdateInfo(categoryNode);
        }
    }

    public boolean isCreationEditionPanel() {
        return this.getManagementAction().getEditPanel() instanceof CategoryCreateDataPanel;
    }
}

