/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.implementations;

import csbase.client.applications.algorithmsmanager.report.core.AbstractTest;
import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import csbase.client.applications.algorithmsmanager.report.implementations.SimpleConfiguratorSource;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import tecgraf.javautils.core.lng.LNG;

public class TestParameterUsage
extends AbstractTest<ParameterStructure> {
    private final SimpleConfiguratorSource algorithms;

    @Override
    public String getName() {
        return LNG.get((String)"TestParameterUsage.name");
    }

    @Override
    public String getDescription() {
        return LNG.get((String)"TestParameterUsage.description");
    }

    public TestParameterUsage(SimpleConfiguratorSource algorithms, Window window) {
        super(window, LNG.get((String)"TestParameterUsage.task.title"), LNG.get((String)"TestParameterUsage.task.message"));
        this.algorithms = algorithms;
    }

    @Override
    public Class<ParameterStructure> getSubjectClass() {
        return ParameterStructure.class;
    }

    @Override
    protected List<IResultMessage<ParameterStructure>> doTest(ParameterStructure subject) {
        ArrayList<IResultMessage<ParameterStructure>> resultMessages = new ArrayList<IResultMessage<ParameterStructure>>();
        Class elementClass = subject.getElementClass();
        if (SimpleParameter.class.isAssignableFrom(elementClass)) {
            for (SimpleAlgorithmConfigurator configurator : this.algorithms) {
                List parameters = configurator.getSimpleParameters();
                Optional<Class> hasParameter = parameters.stream().map(Object::getClass).filter(elementClass::equals).findAny();
                if (!hasParameter.isPresent()) continue;
                String message = LNG.get((String)"TestParameterUsage.result.used", (Object[])new Object[]{configurator.getAlgorithmName()});
                ResultMessage<ParameterStructure> resultMessage = new ResultMessage<ParameterStructure>(subject, TestStatus.OK, message);
                resultMessages.add(resultMessage);
            }
            if (resultMessages.isEmpty()) {
                ResultMessage<ParameterStructure> resultMessage = new ResultMessage<ParameterStructure>(subject, TestStatus.ERROR, LNG.get((String)"TestParameterUsage.result.not.used"));
                resultMessages.add(resultMessage);
            }
        }
        return resultMessages;
    }

    @Override
    public String getSubjectName(ParameterStructure subject) {
        return subject.getElementClass().getSimpleName();
    }
}

