/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.client.applications.algorithmsmanager.PropertiesListener;
import csbase.logic.algorithms.AlgorithmProperty;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;

public class PropertiesPanel {
    private JTextField[] propertiesInputField;
    private List<AlgorithmProperty> algoProperties;
    private Map<String, String> propertiesValues;
    private String title;
    private Window owner;
    private JPanel mainPanel;
    private boolean editable;
    private List<PropertiesListener> propertiesListener;

    public PropertiesPanel(List<AlgorithmProperty> algoProperties, Map<String, String> propertiesValues, String title, Window owner, boolean editable) {
        this.algoProperties = algoProperties;
        this.propertiesValues = propertiesValues;
        this.title = title;
        this.owner = owner;
        this.editable = editable;
        this.propertiesInputField = new JTextField[algoProperties.size()];
        this.propertiesListener = new Vector<PropertiesListener>();
        this.mainPanel = this.buildPanel();
    }

    public JPanel getPropertiesPanel() {
        return this.mainPanel;
    }

    private JPanel buildPanel() {
        int size = this.algoProperties.size();
        JComponent[][] components = new JComponent[size][2];
        for (int i = 0; i < size; ++i) {
            String propKey = this.algoProperties.get(i).getKey();
            String propValue = this.propertiesValues.get(propKey) == null ? "" : this.propertiesValues.get(propKey);
            JTextField inputField = new JTextField(propValue, 30);
            inputField.setEditable(this.editable);
            inputField.addCaretListener(e -> this.notifyPropertyListener(this.wasModified()));
            this.propertiesInputField[i] = inputField;
            components[i][0] = new JLabel(this.algoProperties.get(i).getLabel());
            components[i][1] = inputField;
        }
        JPanel panel = GUIUtils.createBasicGridPanel((JComponent[][])components);
        panel.setBorder(BorderFactory.createTitledBorder(this.title));
        return panel;
    }

    public boolean wasModified() {
        for (int i = 0; i < this.algoProperties.size(); ++i) {
            AlgorithmProperty property = this.algoProperties.get(i);
            String newPropValue = this.propertiesInputField[i].getText().trim();
            String propKey = property.getKey();
            String propValue = this.propertiesValues.get(propKey);
            if (newPropValue.length() == 0 && propValue == null || newPropValue.equals(propValue)) continue;
            return true;
        }
        return false;
    }

    public boolean validateProperties() {
        boolean result = true;
        ArrayList<String> invalidLabels = new ArrayList<String>();
        for (int i = 0; i < this.algoProperties.size(); ++i) {
            String textFieldValue;
            AlgorithmProperty algoProp = this.algoProperties.get(i);
            if (algoProp.isValidValue(textFieldValue = this.propertiesInputField[i].getText().trim())) continue;
            result = false;
            invalidLabels.add(algoProp.getLabel());
        }
        if (!result) {
            String errorTitle = LNG.get((String)"algomanager.title.error") + " - " + this.title;
            StringBuilder msg = new StringBuilder();
            msg.append(LNG.get((String)"algomanager.error.validation.properties.1"));
            msg.append("\n");
            for (String label : invalidLabels) {
                msg.append("\n  - ").append(label);
            }
            msg.append("\n\n");
            msg.append(LNG.get((String)"algomanager.error.validation.properties.2"));
            StandardDialogs.showErrorDialog((Component)this.owner, (String)errorTitle, (String)msg.toString());
        }
        return result;
    }

    public Hashtable<String, String> getProperties() {
        Hashtable<String, String> propsUpdated = new Hashtable<String, String>();
        for (int i = 0; i < this.algoProperties.size(); ++i) {
            AlgorithmProperty property = this.algoProperties.get(i);
            String propKey = property.getKey();
            String newPropValue = this.propertiesInputField[i].getText().trim();
            if (newPropValue.length() <= 0) continue;
            propsUpdated.put(propKey, newPropValue);
        }
        return propsUpdated;
    }

    public void initializeFields(Hashtable<String, String> propertyValues) {
        if (propertyValues == null) {
            return;
        }
        this.propertiesValues = propertyValues;
        for (int i = 0; i < this.propertiesInputField.length; ++i) {
            JTextField field = this.propertiesInputField[i];
            String propKey = this.algoProperties.get(i).getKey();
            String propValue = this.propertiesValues.get(propKey) == null ? "" : this.propertiesValues.get(propKey);
            field.setText(propValue);
        }
    }

    public void enableEdition(boolean state) {
        for (int i = 0; i < this.propertiesInputField.length; ++i) {
            JTextField field = this.propertiesInputField[i];
            field.setEditable(state);
        }
    }

    public void addPropertiesListener(PropertiesListener propertyListener) {
        this.propertiesListener.add(propertyListener);
    }

    public void removePropertiesListener(PropertiesListener propertyListener) {
        this.propertiesListener.remove(propertyListener);
    }

    private void notifyPropertyListener(boolean wasModified) {
        for (PropertiesListener propertyListener : this.propertiesListener) {
            propertyListener.propertiesChanged(wasModified);
        }
    }
}

