/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AbstractVersionTreeNodeAction;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class RemoveDocumentationFiles
extends AbstractVersionTreeNodeAction {
    private final AlgorithmVersionInfo version;
    private final FileInfo[] files;

    public RemoveDocumentationFiles(VersionTree tree, AlgorithmVersionInfo version, FileInfo[] files) {
        super(tree, LNG.get((String)"algomanager.menu.doc.remove"));
        this.version = version;
        this.files = files;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.removeDoc();
    }

    private void removeDoc() {
        new RemoveDocDialog().show();
    }

    private class RemoveDocDialog {
        private RemoveDocDialog() {
        }

        public void show() {
            String removeTitle = LNG.get((String)"algomanager.title.remove_doc");
            Object[] options = new Object[]{LNG.get((String)"algomanager.button.remove"), LNG.get((String)"algomanager.button.cancel")};
            int opt = StandardDialogs.showOptionDialog((Component)RemoveDocumentationFiles.this.getWindow(), (String)removeTitle, (Object)MessageFormat.format(LNG.get((String)"algomanager.msg.confirm.doc_remove"), FormatUtils.format((Object[])RemoveDocumentationFiles.this.files)), (Object[])options);
            if (opt != 0) {
                return;
            }
            boolean success = AlgorithmManagementProxy.removeDocumentationFiles(RemoveDocumentationFiles.this.version, RemoveDocumentationFiles.this.files, RemoveDocumentationFiles.this.getWindow());
            if (!success) {
                StandardErrorDialogs.showErrorDialog(RemoveDocumentationFiles.this.getWindow(), LNG.get((String)"algomanager.title.error") + " - " + removeTitle, LNG.get((String)"algomanager.error.doc_remove"));
            }
        }
    }
}

