/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.actions;

import csbase.client.algorithms.commands.newview.CommandViewFactory;
import csbase.client.algorithms.commands.newview.NewCommandViewUtils;
import csbase.client.algorithms.commands.view.AlgorithmCommandViewFactory;
import csbase.client.algorithms.commands.view.TabType;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.commandsmonitor.CommandsMonitor;
import csbase.client.applications.commandsmonitor.actions.AbstractCommandsAction;
import csbase.client.applications.commandsmonitor.events.DoubleClickEvent;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.event.EventListener;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;

public class ShowCommandParametersAction
extends AbstractCommandsAction
implements EventListener<DoubleClickEvent> {
    public ShowCommandParametersAction(CommandsMonitor application) {
        super(application, false, ApplicationImages.ICON_INFORMATION_16);
    }

    @Override
    protected boolean accept(CommandInfo command) {
        return command.getStatus() != CommandStatus.SCHEDULED && command.getStatus() != CommandStatus.SYSTEM_FAILURE;
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        CommandInfo command = this.getSelectedCommand();
        this.showParameters(command);
    }

    @Override
    public void eventFired(DoubleClickEvent event) {
        CommandInfo command = event.getClicked();
        if (this.accept(command)) {
            this.showParameters(command);
        }
    }

    public void showParameters(CommandInfo command) {
        ApplicationFrame owner = ((CommandsMonitor)this.getApplication()).getApplicationFrame();
        try {
            if (NewCommandViewUtils.useNewVersion()) {
                CommandViewFactory.showCommandView(command, owner, NewCommandViewUtils.getNewTabType(TabType.PARAMETERS));
            } else {
                AlgorithmCommandViewFactory.showView(owner, command, TabType.PARAMETERS);
            }
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog((Window)owner, ((Frame)owner).getTitle(), (Throwable)e);
        }
    }
}

