/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.actions;

import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.FlowTransferable;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.actions.FlowApplicationAction;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.messages.CopyMessage;
import csbase.logic.algorithms.flows.Flow;
import java.awt.event.ActionEvent;
import tecgraf.vix.TypeVS;

public class CopyElementsAction
extends FlowApplicationAction {
    public CopyElementsAction(FlowApplication application) {
        super(application, FlowApplicationUI.COPY_NODE_ICON);
        this.updateEnabledStatus(this.getGraph());
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        Graph graph = this.getGraph();
        Flow flow = Graph.toFlow(null, null, graph.getSelectedNodes(), graph.getSelectedLinks());
        new CopyMessage(new FlowTransferable(flow)).sendVS((TypeVS)graph);
    }

    private Graph getGraph() {
        FlowApplication application = (FlowApplication)this.getApplication();
        Workspace workspace = application.getWorkspace();
        Graph graph = workspace.getGraph();
        return graph;
    }

    @Override
    public void wasElementCreated(Graph graph, GraphElement element) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasElementRemoved(Graph graph, GraphElement element) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasElementSelected(Graph graph, GraphElement element) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasChangedWorkspace(Graph graph) {
        this.updateEnabledStatus(graph);
    }

    private void updateEnabledStatus(Graph graph) {
        this.setEnabled(graph.hasSelectedElements());
    }

    @Override
    public void wasReseted(Graph graph) {
        this.setEnabled(false);
    }
}

