/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.commandviewer;

import csbase.client.algorithms.commands.cache.CommandsCache;
import csbase.client.algorithms.commands.cache.CommandsFilter;
import csbase.client.algorithms.commands.cache.events.AbstractCacheUpdatedEventListener;
import csbase.client.algorithms.commands.newview.CommandViewFactory;
import csbase.client.algorithms.commands.newview.NewCommandViewUtils;
import csbase.client.algorithms.commands.view.AlgorithmCommandViewFactory;
import csbase.client.algorithms.commands.view.TabType;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.commandviewer.AlwaysTrueCommandPropertiesFilter;
import csbase.client.applications.flowapplication.commandviewer.CommandPropertiesFilter;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.facilities.commandtable.CommandStatusCellData;
import csbase.client.facilities.commandtable.CommandStatusCellRenderer;
import csbase.client.facilities.commandtable.CommandStatusHelper;
import csbase.client.kernel.ClientException;
import csbase.client.util.table.ProgressCellRenderer;
import csbase.logic.CommandInfo;
import csbase.logic.ProgressData;
import csbase.logic.Utilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.gui.table.SortableTable;

final class CommandViewerTable
extends SortableTable {
    private static final int COLUMN_COUNT = 8;
    private static final int STATUS_COLUMN_INDEX = 0;
    private static final int STATUS_COLUMN_WIDTH = 50;
    private static final int PROGRESS_COLUMN_INDEX = 1;
    private static final int PROGRESS_COLUMN_WIDTH = 100;
    private static final int USER_COLUMN_INDEX = 2;
    private static final int USER_COLUMN_WIDTH = 75;
    private static final int SGA_NAME_COLUMN_INDEX = 3;
    private static final int SGA_NAME_COLUMN_WIDTH = 75;
    private static final int DESCRIPTION_COLUMN_INDEX = 4;
    private static final int DESCRIPTION_COLUMN_WIDTH = 200;
    private static final int COMMAND_TIP_COLUMN_INDEX = 5;
    private static final int COMMAND_TIP_COLUMN_WIDTH = 125;
    private static final int START_DATE_COLUMN_INDEX = 6;
    private static final int START_DATE_COLUMN_WIDTH = 160;
    private static final int ELAPSED_TIME_INDEX = 7;
    private static final int ELAPSED_TIME_COLUMN_WIDTH = 160;
    private static final String UNKNOWN_CELL_VALUE = "";
    private AbstractCacheUpdatedEventListener listener;
    private final List<CommandInfo> commandInfoList;
    private CommandPropertiesFilter filter;
    private CommandsFilter commandsCacheFilter;
    private Object projectId;
    private AbstractTableModel tableModel;
    private final DesktopComponentFrame owner;

    public CommandViewerTable(DesktopComponentFrame owner, Object projectId) {
        this(owner, projectId, null);
    }

    public CommandViewerTable(DesktopComponentFrame owner, Object projectId, CommandPropertiesFilter filter) {
        this.owner = owner;
        this.commandInfoList = new LinkedList<CommandInfo>();
        this.setProjectId(projectId);
        this.setFilter(filter);
        this.createGui();
        this.createCommandListener(projectId);
        this.loadCommandInfoList();
    }

    public Object getProjectId() {
        return this.projectId;
    }

    public List<CommandInfo> getSelectedCommands() {
        int[] sortedRowsIndex = this.getSelectedRows();
        if (0 == sortedRowsIndex.length) {
            return Collections.emptyList();
        }
        ArrayList<CommandInfo> commands = new ArrayList<CommandInfo>();
        for (int inx = 0; inx < sortedRowsIndex.length; ++inx) {
            int sortedRowIndex = sortedRowsIndex[inx];
            int selectedRowIndex = this.convertRowIndexToModel(sortedRowIndex);
            CommandInfo commandInfo = this.commandInfoList.get(selectedRowIndex);
            commands.add(commandInfo);
        }
        return commands;
    }

    public boolean showSelectedCommand(TabType preferredTab) {
        try {
            List<CommandInfo> commands = this.getSelectedCommands();
            if (1 != commands.size()) {
                return false;
            }
            CommandInfo command = commands.get(0);
            if (NewCommandViewUtils.useNewVersion()) {
                CommandViewFactory.showCommandView(command, this.owner, NewCommandViewUtils.getNewTabType(preferredTab));
            } else {
                AlgorithmCommandViewFactory.showView(this.owner, command, preferredTab);
            }
        }
        catch (ClientException e) {
            return false;
        }
        return true;
    }

    public void start() {
        CommandsCache.getInstance().addEventListener(this.listener);
    }

    public void stop() {
        CommandsCache.getInstance().removeEventListener(this.listener);
    }

    private void createCommandListener(final Object prjId) {
        this.commandsCacheFilter = new CommandsFilter(){

            @Override
            protected final boolean acceptCommand(CommandInfo command) {
                return command.getProjectId().equals(prjId);
            }
        };
        this.listener = new AbstractCacheUpdatedEventListener(this.commandsCacheFilter){

            @Override
            public void eventFired(Collection<CommandInfo> commands) {
                CommandViewerTable.this.loadCommandInfoList(commands);
            }

            @Override
            protected void eventInterrupted(Exception exception, String description) {
                CommandViewerTable.this.owner.getStatusBar().setError(description);
            }
        };
    }

    private void adjustWidths() {
        this.setAutoResizeMode(3);
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableColumn startDateColumn = tableColumnModel.getColumn(6);
        startDateColumn.setPreferredWidth(160);
        TableColumn cmdNameColumn = tableColumnModel.getColumn(5);
        cmdNameColumn.setPreferredWidth(125);
        TableColumn sgaNameColumn = tableColumnModel.getColumn(3);
        sgaNameColumn.setPreferredWidth(75);
        TableColumn userColumn = tableColumnModel.getColumn(2);
        userColumn.setPreferredWidth(75);
        TableColumn descriptionColumn = tableColumnModel.getColumn(4);
        descriptionColumn.setPreferredWidth(200);
        TableColumn progressColumn = tableColumnModel.getColumn(1);
        progressColumn.setPreferredWidth(100);
        TableColumn statusColumn = tableColumnModel.getColumn(0);
        statusColumn.setPreferredWidth(50);
        TableColumn elapsedColumn = tableColumnModel.getColumn(7);
        elapsedColumn.setPreferredWidth(160);
        Dimension intercellSpacing = this.getIntercellSpacing();
        int intercellWidth = intercellSpacing.width;
        int tableWidth = 0;
        tableWidth += intercellWidth;
        int separator = 0;
        TableColumnModel colModel = this.getColumnModel();
        for (int columnIndex = 0; columnIndex < this.getColumnCount(); ++columnIndex) {
            TableColumn column = colModel.getColumn(columnIndex);
            int columnWidth = column.getPreferredWidth();
            tableWidth += separator;
            tableWidth += columnWidth;
            separator = intercellWidth;
        }
        Dimension tableSize = this.getPreferredScrollableViewportSize();
        int tableHeight = tableSize.height;
        this.setPreferredScrollableViewportSize(new Dimension(tableWidth += intercellWidth, tableHeight));
    }

    private Comparator<CommandInfo> createComparator() {
        return new Comparator<CommandInfo>(){

            @Override
            public int compare(CommandInfo o1, CommandInfo o2) {
                if (o1.equals((Object)o2)) {
                    return 0;
                }
                Date startDate1 = o1.getSubmittedDate();
                if (startDate1 == null) {
                    return 1;
                }
                Date startDate2 = o2.getSubmittedDate();
                if (startDate2 == null) {
                    return -1;
                }
                return startDate2.compareTo(startDate1);
            }
        };
    }

    private void createGui() {
        this.createTableModel();
        this.setModel(this.tableModel);
        this.createDescriptionCellRenderer();
        this.createDateCellRenderer();
        this.createProgressCellRenderer();
        this.createElapsedTimeCellRenderer();
        this.setDefaultRenderer(CommandStatusCellData.class, new CommandStatusCellRenderer());
        this.setSelectionMode(2);
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.addMouseListener(this.createMouseListener());
        this.adjustWidths();
        this.selectFirstRow();
    }

    private void createDescriptionCellRenderer() {
        TableColumn column = this.getColumnModel().getColumn(4);
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();
        cellRenderer.setIcon(ApplicationImages.ICON_EDITABLE_TABLE_CELL_14);
        column.setCellRenderer(cellRenderer);
    }

    private void createDateCellRenderer() {
        TableColumn column = this.getColumnModel().getColumn(6);
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                if (value == null) {
                    return;
                }
                Date date = (Date)value;
                String formattedDate = Utilities.getFormattedDate((Date)date);
                this.setText(formattedDate);
            }
        };
        column.setCellRenderer(cellRenderer);
    }

    private void createProgressCellRenderer() {
        TableColumn column = this.getColumnModel().getColumn(1);
        ProgressCellRenderer cellRenderer = new ProgressCellRenderer(UNKNOWN_CELL_VALUE);
        column.setCellRenderer(cellRenderer);
    }

    private void createElapsedTimeCellRenderer() {
        TableColumn column = this.getColumnModel().getColumn(7);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    this.setText(CommandViewerTable.this.getMessage("column.default.value.empty"));
                } else {
                    int wtime = (Integer)value;
                    if (wtime < 0) {
                        this.setText(CommandViewerTable.this.getMessage("column.default.value.error"));
                    } else {
                        String text = FormatUtils.formatInterval((int)wtime);
                        this.setText(text);
                    }
                }
                return this;
            }
        };
        column.setCellRenderer(renderer);
    }

    private MouseListener createMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CommandViewerTable.this.showSelectedCommand(TabType.PARAMETERS);
                }
            }
        };
    }

    private void createTableModel() {
        this.tableModel = new AbstractTableModel(){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 6: {
                        return Date.class;
                    }
                    case 0: {
                        return CommandStatusCellData.class;
                    }
                    case 1: {
                        return ProgressData.class;
                    }
                    case 7: {
                        return Integer.class;
                    }
                }
                return String.class;
            }

            @Override
            public int getColumnCount() {
                return 8;
            }

            @Override
            public String getColumnName(int columnIndex) {
                switch (columnIndex) {
                    case 6: {
                        return CommandViewerTable.this.getMessage("label_column_start_date");
                    }
                    case 5: {
                        return CommandViewerTable.this.getMessage("label_column_command_tip");
                    }
                    case 3: {
                        return CommandViewerTable.this.getMessage("label_column_sga_name");
                    }
                    case 2: {
                        return CommandViewerTable.this.getMessage("label_column_user_login");
                    }
                    case 4: {
                        return CommandViewerTable.this.getMessage("label_column_description");
                    }
                    case 1: {
                        return CommandViewerTable.this.getMessage("label_column_progress");
                    }
                    case 0: {
                        return CommandViewerTable.this.getMessage("label_column_status");
                    }
                    case 7: {
                        return CommandViewerTable.this.getMessage("label_column_elapsed_time");
                    }
                }
                String errorMessage = String.format("\u00cdndice de coluna inv\u00e1lido.\n\u00cdndice passado: %d.\n", columnIndex);
                throw new IllegalArgumentException(errorMessage);
            }

            @Override
            public int getRowCount() {
                return CommandViewerTable.this.commandInfoList.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                CommandInfo commandInfo = CommandViewerTable.this.getCommandInfo(rowIndex);
                switch (columnIndex) {
                    case 6: {
                        return commandInfo.getSubmittedDate();
                    }
                    case 5: {
                        return commandInfo.getTip();
                    }
                    case 3: {
                        String sgaName = commandInfo.getSGAName();
                        if (sgaName == null) {
                            return CommandViewerTable.UNKNOWN_CELL_VALUE;
                        }
                        return sgaName;
                    }
                    case 2: {
                        Object userId = commandInfo.getUserId();
                        if (userId == null) {
                            return CommandViewerTable.UNKNOWN_CELL_VALUE;
                        }
                        return userId;
                    }
                    case 4: {
                        String description = commandInfo.getDescription();
                        if (description == null) {
                            return CommandViewerTable.UNKNOWN_CELL_VALUE;
                        }
                        return description;
                    }
                    case 1: {
                        ProgressData progressData = commandInfo.getProgressData();
                        return progressData;
                    }
                    case 0: {
                        return CommandStatusHelper.createCellData(commandInfo);
                    }
                    case 7: {
                        return commandInfo.getWallTimeSec();
                    }
                }
                String errorMessage = String.format("\u00cdndice de coluna inv\u00e1lido.\n\u00cdndice passado: %d.\n", columnIndex);
                throw new IllegalArgumentException(errorMessage);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 4;
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                CommandInfo commandInfo;
                if (columnIndex == 4 && (commandInfo = CommandViewerTable.this.getCommandInfo(rowIndex)) != null) {
                    String description = (String)value;
                    if (description.length() == 0) {
                        description = null;
                    }
                    String previousDescription = commandInfo.getDescription();
                    commandInfo.setDescription(description);
                    if (CommandViewerTable.this.updateCommandInfo(commandInfo)) {
                        this.fireTableCellUpdated(rowIndex, columnIndex);
                    } else {
                        commandInfo.setDescription(previousDescription);
                    }
                }
                super.setValueAt(value, rowIndex, columnIndex);
            }
        };
    }

    private void filterCommandsInfo(Collection<CommandInfo> commandInfoSet) {
        Iterator<CommandInfo> commandInfoIterator = commandInfoSet.iterator();
        while (commandInfoIterator.hasNext()) {
            CommandInfo commandInfo = commandInfoIterator.next();
            if (this.filterCommandInfo(commandInfo)) continue;
            commandInfoIterator.remove();
        }
    }

    private boolean filterCommandInfo(CommandInfo commandInfo) {
        return this.filter.accept(commandInfo);
    }

    private CommandInfo getCommandInfo(int rowIndex) {
        CommandInfo commandInfo = this.commandInfoList.get(rowIndex);
        return commandInfo;
    }

    private String getMessage(String keySuffix) {
        return LNG.get((String)(((Object)((Object)this)).getClass().getSimpleName() + "." + keySuffix));
    }

    private Window getWindow() {
        return SwingUtilities.getWindowAncestor((Component)((Object)this));
    }

    public int convertRowIndexToView(int modelRowIndex) {
        if (modelRowIndex < 0) {
            return -1;
        }
        if (this.getModel() == null) {
            return -1;
        }
        if (modelRowIndex >= this.getModel().getRowCount()) {
            return -1;
        }
        return super.convertRowIndexToView(modelRowIndex);
    }

    private void loadCommandInfoList() {
        RemoteTask<Collection<CommandInfo>> task = new RemoteTask<Collection<CommandInfo>>(){

            protected void performTask() throws Exception {
                Collection<CommandInfo> commands = CommandsCache.getInstance().getCommands(CommandViewerTable.this.commandsCacheFilter);
                this.setResult(commands);
            }
        };
        String taskTitle = LNG.get((String)"CommandViewerTable.msg_reading_command_title");
        String taskMessage = LNG.get((String)"CommandViewerTable.msg_reading_command_title");
        if (!task.execute(this.getWindow(), taskTitle, taskMessage)) {
            return;
        }
        Collection commands = (Collection)task.getResult();
        this.loadCommandInfoList(commands);
    }

    private void loadCommandInfoList(final Collection<CommandInfo> commands) {
        this.filterCommandsInfo(commands);
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                final List<CommandInfo> selecteds = CommandViewerTable.this.getSelectedCommands();
                CommandViewerTable.this.commandInfoList.clear();
                CommandViewerTable.this.commandInfoList.addAll(commands);
                CommandViewerTable.this.sortCommandInfoList();
                CommandViewerTable.this.tableModel.fireTableDataChanged();
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CommandViewerTable.this.clearSelection();
                        for (int inx = 0; inx < CommandViewerTable.this.commandInfoList.size(); ++inx) {
                            int selectedInx;
                            CommandInfo cmd = (CommandInfo)CommandViewerTable.this.commandInfoList.get(inx);
                            if (!selecteds.contains(cmd) || -1 >= (selectedInx = CommandViewerTable.this.convertRowIndexToView(inx))) continue;
                            CommandViewerTable.this.addRowSelectionInterval(selectedInx, selectedInx);
                        }
                    }
                });
            }
        });
    }

    private void selectFirstRow() {
        if (!this.commandInfoList.isEmpty()) {
            this.changeSelection(0, 0, false, false);
        }
    }

    private void setFilter(CommandPropertiesFilter filter) {
        this.filter = filter == null ? new AlwaysTrueCommandPropertiesFilter() : filter;
    }

    private void setProjectId(Object projectId) {
        if (projectId == null) {
            throw new IllegalArgumentException("projectId == null");
        }
        this.projectId = projectId;
    }

    private void sortCommandInfoList() {
        Collections.sort(this.commandInfoList, this.createComparator());
    }

    private boolean updateCommandInfo(final CommandInfo commandInfo) {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws RemoteException {
                CommandsCache.getInstance().updateDescription(commandInfo);
            }
        };
        String taskTitle = this.getMessage("msg_saving_command_title");
        String commandId = commandInfo.getId();
        String taskMessage = String.format(this.getMessage("msg_saving_command_content"), commandId);
        return task.execute(this.getWindow(), taskTitle, taskMessage);
    }
}

