/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.filters;

import csbase.client.applications.flowapplication.CompassDirection;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.messages.ChangeCursorMessage;
import csbase.client.applications.flowapplication.messages.PickNodeMessage;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import tecgraf.vix.TypeVO;

public final class ResizeNodeFilter
extends WorkspaceFilter {
    private static final int START = 0;
    private static final int WAITING_PRESS_TO_RESIZE_NODE = 1;
    private static final int WAITING_DRAG_TO_RESIZE_NODE = 2;
    private CompassDirection compassDirection;
    private GraphNode currentNode;
    private int currentState = 0;

    public ResizeNodeFilter(Workspace workspace) {
        super(workspace);
    }

    public void callbackButton(Point2D pt, MouseEvent ev) {
        boolean eventWasConsumed = false;
        switch (this.currentState) {
            case 1: {
                if (!this.wasPressed(ev)) break;
                this.currentState = 2;
                eventWasConsumed = true;
                break;
            }
            case 2: {
                if (!this.wasReleased(ev)) break;
                this.unmarkResizeNode();
            }
        }
        if (!eventWasConsumed) {
            super.callbackButton(pt, ev);
        }
    }

    public void callbackDrag(Point2D pt, MouseEvent ev) {
        if (this.currentState == 2) {
            this.currentNode.resize(pt, this.compassDirection);
            this.repaint();
        } else {
            super.callbackDrag(pt, ev);
        }
    }

    public void callbackMove(Point2D pt, MouseEvent ev) {
        switch (this.currentState) {
            case 0: {
                this.pickNode(pt);
                if (this.currentNode == null) break;
                this.compassDirection = this.currentNode.getCompassDirection(pt);
                if (this.compassDirection != null) {
                    this.changeCursor(this.getCursor());
                    this.currentState = 1;
                    break;
                }
                this.compassDirection = null;
                this.currentNode = null;
                break;
            }
            case 1: {
                CompassDirection newCompassDirection;
                boolean unmark = true;
                this.pickNode(pt);
                if (this.currentNode != null && (newCompassDirection = this.currentNode.getCompassDirection(pt)) != null) {
                    if (!this.compassDirection.equals(newCompassDirection)) {
                        this.compassDirection = newCompassDirection;
                        this.changeCursor(this.getCursor());
                    }
                    unmark = false;
                }
                if (!unmark) break;
                this.unmarkResizeNode();
            }
        }
        super.callbackMove(pt, ev);
    }

    @Override
    public void wasElementRemoved(Graph graph, GraphElement element) {
        this.reset();
    }

    @Override
    public void wasReseted(Graph graph) {
        this.reset();
    }

    private void changeCursor(Cursor cursor) {
        if (this.getVS() != null) {
            new ChangeCursorMessage(cursor).sendVS(this.getVS());
        }
    }

    private void pickNode(Point2D pt) {
        PickNodeMessage message = new PickNodeMessage(pt);
        message.sendVO((TypeVO)this);
        this.currentNode = message.getNode();
    }

    private void reset() {
        this.unmarkResizeNode();
        if (this.getVS() != null) {
            this.changeCursor(this.getDefaultCursor());
        }
    }

    private void unmarkResizeNode() {
        this.changeCursor(this.getDefaultCursor());
        this.compassDirection = null;
        this.currentNode = null;
        this.currentState = 0;
    }

    private Cursor getCursor() {
        return Cursor.getPredefinedCursor(this.getCursorType());
    }

    private int getCursorType() {
        if (CompassDirection.NORTH.equals(this.compassDirection)) {
            return 8;
        }
        if (CompassDirection.SOUTH.equals(this.compassDirection)) {
            return 9;
        }
        if (CompassDirection.EAST.equals(this.compassDirection)) {
            return 11;
        }
        if (CompassDirection.WEST.equals(this.compassDirection)) {
            return 10;
        }
        if (CompassDirection.NORTH_EAST.equals(this.compassDirection)) {
            return 7;
        }
        if (CompassDirection.NORTH_WEST.equals(this.compassDirection)) {
            return 6;
        }
        if (CompassDirection.SOUTH_EAST.equals(this.compassDirection)) {
            return 5;
        }
        if (CompassDirection.SOUTH_WEST.equals(this.compassDirection)) {
            return 4;
        }
        return 0;
    }

    private Cursor getDefaultCursor() {
        return Cursor.getPredefinedCursor(0);
    }

    private boolean wasPressed(MouseEvent ev) {
        return ev.getButton() == 1 && ev.getID() == 501;
    }

    private boolean wasReleased(MouseEvent ev) {
        return ev.getButton() == 1 && ev.getID() == 502;
    }
}

