/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph.actions;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddNodePopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.ParametersTransferable;
import csbase.client.applications.flowapplication.graph.actions.Action;
import csbase.client.applications.flowapplication.graph.actions.GraphElementAction;
import csbase.client.applications.flowapplication.messages.CopyMessage;
import csbase.exception.algorithms.ParameterNotFoundException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.util.Set;
import tecgraf.vix.TypeVS;

public final class CopyParameterValuesAction
extends GraphElementAction {
    public CopyParameterValuesAction(GraphNode node) {
        super(node, CopyParameterValuesAction.class.getName() + ".name", ApplicationImages.ICON_COPY_16);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GraphNode node = (GraphNode)this.getElement();
        this.saveToClipboard(node);
        new CopyMessage(new ParametersTransferable(node)).sendVS((TypeVS)node);
    }

    public static WorkspaceFilter createFilter(Workspace workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("O par\u00e2metro workspace est\u00e1 nulo.");
        }
        return new AddNodePopupActionFilter(workspace){

            @Override
            protected Action createAction(GraphNode graphNode, Point2D point) {
                return new CopyParameterValuesAction(graphNode);
            }
        };
    }

    private void saveToClipboard(GraphNode node) {
        Set<String> parameterNames = node.getParameterNames();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringBuilder builder = new StringBuilder();
        for (String parameterName : parameterNames) {
            String parameterType;
            String parameterValue;
            String parameterLabel;
            try {
                parameterLabel = node.getParameterLabel(parameterName);
                parameterValue = node.getParameterValue(parameterName);
                parameterType = node.getParameterType(parameterName);
            }
            catch (ParameterNotFoundException e) {
                return;
            }
            builder.append(parameterLabel);
            builder.append(" = ");
            builder.append(parameterValue);
            builder.append(" (");
            builder.append(parameterType);
            builder.append(" )");
            builder.append("\n");
        }
        clipboard.setContents(new StringSelection(builder.toString()), null);
    }
}

