/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.Client;
import csbase.client.desktop.DesktopErrorEvent;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.DesktopWindowInterface;
import csbase.client.desktop.GlassPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StatusBar;

public class DesktopComponentFrame
extends JFrame
implements DesktopWindowInterface {
    private final JPanel frameContents;
    private StatusBar statusBar;
    private Object index = null;
    protected DesktopComponentFrame owner;
    private static boolean showServerName = Client.getInstance().showServerName();
    private static Map<Object, DesktopComponentFrame> openedFrames = new HashMap<Object, DesktopComponentFrame>();
    private static Object focusedWindowIndex;

    public DesktopComponentFrame() {
        this(null, null, "");
    }

    public DesktopComponentFrame(String title) {
        this(null, null, title);
    }

    public DesktopComponentFrame(Object index, DesktopComponentFrame owner, String title) {
        this.owner = owner;
        this.setTitle(title);
        this.setStandardIcon();
        this.setDefaultCloseOperation(0);
        this.frameContents = new JPanel(new BorderLayout());
        this.statusBar = new StatusBar();
        Container cp = super.getContentPane();
        cp.add((Component)this.frameContents, "Center");
        cp.add((Component)this.statusBar, "South");
        DesktopFrame dktFrame = DesktopFrame.getInstance();
        if (dktFrame != null) {
            dktFrame.addWindow(this);
        }
        this.index = index;
        if (this.index == null) {
            Set<Object> existingKeys = openedFrames.keySet();
            int i = 0;
            while (existingKeys.contains("DesktopComponentFrame" + i)) {
                ++i;
            }
            this.index = "DesktopComponentFrame" + i;
        }
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent arg0) {
                focusedWindowIndex = DesktopComponentFrame.this.getIndex();
            }

            @Override
            public void windowLostFocus(WindowEvent arg0) {
            }
        });
        DesktopComponentFrame.putDesktopComponentFrame(this.index, this);
        this.setGlassPane(new GlassPane());
    }

    public Object getIndex() {
        return this.index;
    }

    @Override
    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        if (isVisible && this.getExtendedState() == 1) {
            this.setExtendedState(0);
        }
    }

    public void center(Window window) {
        JFrame jframe;
        int windowState;
        if (window instanceof JFrame && (((windowState = (jframe = (JFrame)window).getExtendedState()) & 6) != 0 || window.getHeight() == 0)) {
            GUIUtils.centerOnScreen((Window)this);
            return;
        }
        this.center(window.getSize(), window.getX(), window.getY());
    }

    public void center(Dimension dimension, int x, int y) {
        int newY;
        Dimension wSize = this.getSize();
        int newX = x + (dimension.width - wSize.width) / 2;
        if (newX < 0) {
            newX = 0;
        }
        if ((newY = y + (dimension.height - wSize.height) / 2) < 0) {
            newY = 0;
        }
        this.setLocation(newX, newY);
    }

    private void setStandardIcon() {
        DesktopFrame dktFrame = DesktopFrame.getInstance();
        Image img = null;
        if (dktFrame != null) {
            img = dktFrame.getFrameImage();
        }
        if (img != null) {
            this.setIconImage(img);
        }
    }

    @Override
    public void close() {
        DesktopFrame dktFrame = DesktopFrame.getInstance();
        if (dktFrame != null) {
            dktFrame.removeWindow(this);
        }
        if (this.index != null) {
            DesktopComponentFrame.removeDesktopComponentFrame(this.index);
        }
        this.statusBar.shutdownTimer();
        super.dispose();
    }

    @Override
    @Deprecated
    public final void dispose() {
        this.close();
    }

    @Override
    public Container getContentPane() {
        return this.frameContents;
    }

    public void signalError(DesktopErrorEvent errorEvent) {
        JComponent[] disabledComponents = errorEvent.disabledComponents;
        if (disabledComponents != null) {
            for (int i = 0; i < disabledComponents.length; ++i) {
                disabledComponents[i].setEnabled(false);
            }
        }
        if (errorEvent.signaller != null) {
            DesktopFrame dktFrame = DesktopFrame.getInstance();
            Image img = null;
            if (dktFrame != null) {
                img = dktFrame.getDesktopErrorImage();
            }
            if (dktFrame != null && img != null) {
                errorEvent.signaller.setIcon(new ImageIcon(img));
            }
        }
        this.statusBar.setError(errorEvent.errorMessage != null, errorEvent.errorMessage);
    }

    public void resetError(DesktopErrorEvent errorEvent) {
        JComponent[] disabledComponents = errorEvent.disabledComponents;
        if (disabledComponents != null) {
            for (int i = 0; i < disabledComponents.length; ++i) {
                disabledComponents[i].setEnabled(true);
            }
        }
        if (errorEvent.signaller != null) {
            errorEvent.signaller.setIcon(null);
        }
        this.statusBar.hideStatusBar(errorEvent.errorMessage != null);
    }

    public void showMessage(String title, Object msg, int type) {
        JOptionPane.showMessageDialog(this, msg, title, type);
    }

    public void showStatusBar() {
        this.statusBar.showStatusBar();
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setStatusBar(StatusBar statusBar) {
        Container cp = super.getContentPane();
        cp.remove((Component)this.statusBar);
        this.statusBar = statusBar;
        cp.add((Component)statusBar, "South");
        cp.validate();
    }

    @Override
    public void setTitle(String title) {
        DesktopFrame dktFrame = DesktopFrame.getInstance();
        String newTitle = title;
        if (dktFrame != null) {
            newTitle = dktFrame.adjustTitle(title);
        }
        super.setTitle(newTitle);
    }

    public static DesktopComponentFrame getDesktopComponentFrame(Object id) {
        DesktopComponentFrame frame = openedFrames.get(id);
        return frame;
    }

    protected static void putDesktopComponentFrame(Object id, DesktopComponentFrame frame) {
        openedFrames.put(id, frame);
    }

    protected static void removeDesktopComponentFrame(Object id) {
        openedFrames.remove(id);
    }

    public static DesktopComponentFrame getFocusedWindow() {
        return openedFrames.get(focusedWindowIndex);
    }
}

