/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.ias.ManagerPanel;
import csbase.client.ias.PermissionManagerPanel;
import csbase.client.ias.PlatformManagerPanel;
import csbase.client.ias.RoleManagerPanel;
import csbase.client.ias.UserGroupManagerPanel;
import csbase.client.ias.UserManagerPanel;
import csbase.client.ias.server.ServerInfoManagerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import tecgraf.javautils.core.lng.LNG;

public class AdminFrame {
    protected DesktopComponentFrame mainFrame;
    protected JTabbedPane tabbedPane;
    protected Component[] panes;

    private JPanel makePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.makeTabbedPane(), "Center");
        panel.add((Component)this.makeCloseButton(), "South");
        return panel;
    }

    protected JComponent makeTabbedPane() {
        JPanel ptb = new JPanel(new GridLayout(1, 1));
        this.tabbedPane = new JTabbedPane();
        this.panes = new Component[6];
        this.panes[0] = new UserManagerPanel(this.mainFrame);
        this.tabbedPane.addTab(LNG.get((String)"IAS_USERS"), this.panes[0]);
        this.panes[1] = new UserGroupManagerPanel(this.mainFrame);
        this.tabbedPane.addTab(LNG.get((String)"IAS_USERGROUPS"), this.panes[1]);
        this.panes[2] = new RoleManagerPanel(this.mainFrame);
        this.tabbedPane.addTab(LNG.get((String)"IAS_ROLES"), this.panes[2]);
        this.panes[3] = new PermissionManagerPanel(this.mainFrame);
        this.tabbedPane.addTab(LNG.get((String)"IAS_PERMISSIONS"), this.panes[3]);
        this.panes[4] = new PlatformManagerPanel(this.mainFrame);
        this.tabbedPane.addTab(LNG.get((String)"IAS_PLATFORMS"), this.panes[4]);
        this.panes[5] = new ServerInfoManagerPanel(this.mainFrame);
        this.tabbedPane.addTab(LNG.get((String)"IAS_SERVERS"), this.panes[5]);
        ptb.add(this.tabbedPane);
        return ptb;
    }

    private JComponent makeCloseButton() {
        JPanel buttonPanel = new JPanel();
        JButton closeButton = new JButton(LNG.get((String)"IAS_CLOSE"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdminFrame.this.close();
            }
        });
        buttonPanel.add(closeButton);
        return buttonPanel;
    }

    public void bringToFront() {
        this.mainFrame.setVisible(true);
        this.mainFrame.toFront();
    }

    public void close() {
        for (int i = 0; i < this.panes.length; ++i) {
            if (!(this.panes[i] instanceof ManagerPanel)) continue;
            ((ManagerPanel)this.panes[i]).beforeClose();
        }
        if (this.mainFrame != null) {
            this.mainFrame.close();
            this.mainFrame = null;
        }
    }

    public AdminFrame() {
        this.makeMainFrame();
    }

    public void makeMainFrame() {
        this.mainFrame = new DesktopComponentFrame(LNG.get((String)"IAS_ADMINISTRATION_TITLE"));
        this.mainFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AdminFrame.this.close();
            }
        });
        this.mainFrame.getContentPane().add((Component)this.makePanel(), "Center");
        this.mainFrame.pack();
        this.mainFrame.setMinimumSize(new Dimension(800, 500));
        if (DesktopFrame.getInstance() == null) {
            this.mainFrame.setLocationRelativeTo(null);
        } else {
            this.mainFrame.center(DesktopFrame.getInstance().getDesktopFrame());
        }
    }

    public void showUserManagement() {
        if (this.mainFrame == null) {
            this.makeMainFrame();
        }
        this.tabbedPane.setSelectedIndex(0);
        this.mainFrame.setVisible(true);
    }

    public void showUserGroupManagement() {
        if (this.mainFrame == null) {
            this.makeMainFrame();
        }
        this.tabbedPane.setSelectedIndex(1);
        this.mainFrame.setVisible(true);
    }

    public void showRoleManagement() {
        if (this.mainFrame == null) {
            this.makeMainFrame();
        }
        this.tabbedPane.setSelectedIndex(2);
        this.mainFrame.setVisible(true);
    }

    public void showPermissionManagement() {
        if (this.mainFrame == null) {
            this.makeMainFrame();
        }
        this.tabbedPane.setSelectedIndex(3);
        this.mainFrame.setVisible(true);
    }

    public void showPlatformManagement() {
        if (this.mainFrame == null) {
            this.makeMainFrame();
        }
        this.tabbedPane.setSelectedIndex(4);
        this.mainFrame.setVisible(true);
    }

    public void showServerManagement() {
        if (this.mainFrame == null) {
            this.makeMainFrame();
        }
        this.tabbedPane.setSelectedIndex(5);
        this.mainFrame.setVisible(true);
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }
}

