/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.util.SwingObserver;
import csbase.logic.AdministrationEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.SortableTable;

public abstract class ManagerPanel
extends JPanel
implements SwingObserver {
    protected static final int IDENTIFIER_INDEX = 0;
    private static final int INITIAL_SORTED_COLUMN_INDEX = 1;
    private SortableTable table;
    private JButton modifyButton;
    private JButton removeButton;
    private JButton addButton;
    private EnablerListSelectionListener selectionListener = new EnablerListSelectionListener();

    protected void setItems(Vector items) {
        if (items == null) {
            throw new IllegalArgumentException("items == null");
        }
        if (this.table == null) {
            throw new IllegalStateException("table == null");
        }
        ObjectTableModel model = (ObjectTableModel)this.table.getModel();
        model.setRows((List)items);
    }

    public void make(TableModel model) {
        this.make(model, null, false);
    }

    public void make(TableModel model, boolean hasSearchField) {
        this.make(model, null, hasSearchField);
    }

    public void make(TableModel model, Comparator[] comparators, boolean hasSearchField) {
        if (model == null) {
            throw new IllegalArgumentException("model == null");
        }
        this.setLayout(new BorderLayout());
        if (comparators == null) {
            this.add((Component)this.makeTable(model), "Center");
        } else {
            this.add((Component)this.makeTable(model, comparators), "Center");
        }
        this.add((Component)this.makeButtons(hasSearchField), "South");
    }

    protected JComponent makeTable(TableModel model) {
        this.table = new SortableTable(model);
        this.table.removeColumn(this.table.getColumnModel().getColumn(0));
        this.table.sort(1, SortOrder.ASCENDING);
        this.table.setSelectionMode(0);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
        JScrollPane scrollpane = new JScrollPane((Component)this.table);
        return scrollpane;
    }

    protected JComponent makeTable(TableModel model, Comparator[] comparators) {
        this.table = new SortableTable(model);
        this.table.sort(1, SortOrder.ASCENDING);
        this.table.setComparators(comparators);
        this.table.removeColumn(this.table.getColumnModel().getColumn(0));
        this.table.setSelectionMode(0);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
        JScrollPane scrollpane = new JScrollPane((Component)this.table);
        return scrollpane;
    }

    protected JPanel makeButtons() {
        JPanel panel = new JPanel();
        this.createModifyButton(panel, false);
        this.createRemoveButton(panel, false);
        this.createAddButton(panel, true);
        JComponent[] buttons = new JComponent[]{this.addButton, this.removeButton, this.modifyButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        return panel;
    }

    private JPanel makeButtons(boolean hasSearchField) {
        if (hasSearchField) {
            JPanel panel = new JPanel(new BorderLayout());
            JPanel searchPanel = this.table.createSearchPanel(LNG.get((String)"IAS_SEARCH_IN_SELECTED_COLUMN") + ":", null, LNG.get((String)"IAS_PREVIOUS"), LNG.get((String)"IAS_NEXT"), 5, true);
            panel.add((Component)searchPanel, "North");
            panel.add((Component)this.makeButtons(), "South");
            return panel;
        }
        return this.makeButtons();
    }

    private void createAddButton(JPanel panel, boolean enabled) {
        this.addButton = new JButton(LNG.get((String)"IAS_ADD"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManagerPanel.this.add();
            }
        });
        this.addButton.setEnabled(enabled);
        panel.add(this.addButton);
    }

    private void createRemoveButton(JPanel panel, boolean enabled) {
        this.removeButton = new JButton(LNG.get((String)"IAS_REMOVE"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ManagerPanel.this.table.getSelectedRow();
                Object id = ManagerPanel.this.getRowId(row);
                ManagerPanel.this.delete(id);
            }
        });
        this.removeButton.setEnabled(enabled);
        panel.add(this.removeButton);
        this.addButtonToSelectionListener(this.removeButton);
    }

    private void createModifyButton(JPanel panel, boolean enabled) {
        this.modifyButton = new JButton(LNG.get((String)"IAS_UPDATE"));
        this.modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = ManagerPanel.this.table.getSelectedRow();
                Object id = ManagerPanel.this.getRowId(row);
                ManagerPanel.this.modify(id);
            }
        });
        this.modifyButton.setEnabled(enabled);
        panel.add(this.modifyButton);
        this.addButtonToSelectionListener(this.modifyButton);
    }

    @Override
    public void doUpdate(Observable observable, Object arg) {
        AdministrationEvent action = (AdministrationEvent)arg;
        Object item = action.item;
        ObjectTableModel model = (ObjectTableModel)this.table.getModel();
        switch (action.type) {
            case 1: {
                model.add(item);
                break;
            }
            case 2: {
                model.modify(item);
                break;
            }
            case 3: {
                model.remove(item);
            }
        }
    }

    public abstract void add();

    public abstract void modify(Object var1);

    public abstract void delete(Object var1);

    public abstract void beforeClose();

    protected ManagerPanel() {
    }

    protected SortableTable getTable() {
        return this.table;
    }

    protected void addButtonToSelectionListener(JButton button) {
        this.selectionListener.addButton(button);
    }

    protected void removeButtonFromSelectionListener(JButton button) {
        this.selectionListener.removeButton(button);
    }

    protected Object getRowId(int row) {
        return this.table.getModel().getValueAt(this.table.convertRowIndexToModel(row), 0);
    }

    private class EnablerListSelectionListener
    implements ListSelectionListener {
        private ArrayList buttons = new ArrayList();

        public void addButton(JButton button) {
            this.buttons.add(button);
        }

        public void removeButton(JButton button) {
            this.buttons.remove(button);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Iterator buttonsIterator = this.buttons.iterator();
            boolean enabled = ManagerPanel.this.table.getSelectedRowCount() != 0;
            while (buttonsIterator.hasNext()) {
                JButton button = (JButton)buttonsIterator.next();
                button.setEnabled(enabled);
            }
        }
    }
}

