/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.ias.ManagerPanel;
import csbase.client.ias.PermissionInfoDialog;
import csbase.client.ias.PermissionUserDefinitionDialog;
import csbase.client.remote.srvproxies.PermissionProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.SwingObserverWrapper;
import csbase.logic.Permission;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class PermissionManagerPanel
extends ManagerPanel {
    private JFrame parent;
    private JButton associateButton;
    private static final int debug = 0;

    public PermissionManagerPanel(JFrame parent) {
        this.parent = parent;
        Vector<Object> permissions = PermissionProxy.getAllPermissions(parent, parent.getTitle(), LNG.get((String)"IAS_WAITING_ADMIN_DATA"));
        if (permissions == null) {
            permissions = new Vector();
        }
        Collections.sort(permissions);
        DefaultObjectTableProvider provider = new DefaultObjectTableProvider(){

            public Object[] getCellValues(Object item) {
                Permission permission = (Permission)item;
                if (permission == null) {
                    return null;
                }
                return new Object[]{permission.getId(), permission.getName(), permission.getDescription()};
            }

            public String[] getColumnNames() {
                return new String[]{null, LNG.get((String)"IAS_PERMISSION"), LNG.get((String)"IAS_DESCRIPTION")};
            }

            public Class<?>[] getColumnClasses() {
                return new Class[]{Object.class, String.class, String.class};
            }
        };
        ObjectTableModel model = new ObjectTableModel(permissions, (ObjectTableProvider)provider);
        Comparator[] comparators = new Comparator[]{null, ClientUtilities.getStringComparatorIgnoreCase(), ClientUtilities.getStringComparatorIgnoreCase()};
        this.make((TableModel)model, comparators, false);
        Permission.addObserver((Observer)new SwingObserverWrapper(this));
    }

    @Override
    public void beforeClose() {
        Permission.deleteObserver((Observer)new SwingObserverWrapper(this));
    }

    @Override
    public void add() {
        new PermissionInfoDialog((Window)this.parent);
    }

    @Override
    public void modify(Object id) {
        Permission permission = this.getPermission(id);
        if (permission == null) {
            return;
        }
        new PermissionInfoDialog((Window)this.parent, permission);
    }

    @Override
    public void delete(Object id) {
        Permission permission = this.getPermission(id);
        if (permission == null) {
            return;
        }
        String permissionName = permission.getName();
        int res = StandardDialogs.showYesNoDialog((Component)this.parent, (String)this.parent.getTitle(), (Object)MessageFormat.format(LNG.get((String)"IAS_PERMISSION_MGR_PERMISSION_REMOVAL_CONFIRMATION"), permissionName));
        if (res == 0) {
            PermissionProxy.deletePermission(this.parent, this.parent.getTitle(), MessageFormat.format(LNG.get((String)"IAS_PERMISSION_MGR_WAITING_REMOVE_PERMISSION"), permissionName), id);
        }
    }

    protected void displayMessage(String title, String message) {
        StandardDialogs.showInfoDialog((Component)this.parent, (String)title, (Object)message);
    }

    protected void displayError(String message) {
        StandardErrorDialogs.showErrorDialog((Window)this.parent, this.parent.getTitle(), message);
    }

    @Override
    protected JPanel makeButtons() {
        JPanel panel = super.makeButtons();
        panel.add(new JPanel());
        this.createAssociateButton(panel, false);
        return panel;
    }

    private void createAssociateButton(JPanel panel, boolean enabled) {
        this.associateButton = new JButton(LNG.get((String)"IAS_PERMISSION_USERS_BUTTON"));
        this.associateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = PermissionManagerPanel.this.getTable().getSelectedRow();
                Object id = PermissionManagerPanel.this.getRowId(row);
                PermissionManagerPanel.this.associate(id);
            }
        });
        this.associateButton.setEnabled(enabled);
        panel.add(this.associateButton);
        this.addButtonToSelectionListener(this.associateButton);
    }

    protected void associate(Object id) {
        Permission permission = this.getPermission(id);
        if (permission == null) {
            return;
        }
        new PermissionUserDefinitionDialog(this.parent).showDialog(permission);
    }

    private Permission getPermission(Object id) {
        Permission permission = PermissionProxy.getPermission(this.parent, this.parent.getTitle(), LNG.get((String)"IAS_WAITING_PERMISSION"), id);
        if (permission == null) {
            this.displayError(LNG.get((String)"IAS_PERMISSION_MGR_PERMISSION_NOT_FOUND"));
        }
        return permission;
    }
}

