/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote;

import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.AdministrationEvent;
import csbase.logic.Permission;
import csbase.logic.Platform;
import csbase.logic.Role;
import csbase.logic.User;
import csbase.logic.UserGroup;
import csbase.util.messages.IMessageListener;
import csbase.util.messages.Message;
import java.rmi.RemoteException;
import tecgraf.javautils.core.lng.LNG;

public class AdministrationObserver {
    private static AdministrationObserver instance = null;
    private IMessageListener listener = new IMessageListener(){

        public void onMessagesReceived(Message ... messages) throws Exception {
            for (Message message : messages) {
                AdministrationEvent event = (AdministrationEvent)message.getBody();
                try {
                    if (event.item instanceof User) {
                        User.update((AdministrationEvent)event);
                        continue;
                    }
                    if (event.item instanceof UserGroup) {
                        UserGroup.update((AdministrationEvent)event);
                        continue;
                    }
                    if (event.item instanceof Role) {
                        Role.update((AdministrationEvent)event);
                        continue;
                    }
                    if (event.item instanceof Platform) {
                        Platform.update((AdministrationEvent)event);
                        continue;
                    }
                    if (!(event.item instanceof Permission)) continue;
                    Permission.update((AdministrationEvent)event);
                }
                catch (Exception e) {
                    StandardErrorDialogs.showErrorDialog(null, LNG.get((String)"ERRO"), (Throwable)e);
                }
            }
        }
    };

    public static void start() throws Exception {
        if (instance != null) {
            return;
        }
        instance = new AdministrationObserver();
    }

    public static void stop() throws RemoteException {
        if (instance == null) {
            return;
        }
        instance.uninstall();
    }

    public void install() {
        MessageProxy.addListener(this.listener, AdministrationEvent.class);
    }

    public void uninstall() {
        MessageProxy.removeListener(this.listener);
    }

    protected AdministrationObserver() throws Exception {
        this.install();
    }
}

