/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.manager.server;

import csbase.client.remote.manager.server.ServerInfoManagerListener;
import csbase.client.remote.manager.server.ServerServiceRemoteObserver;
import csbase.logic.User;
import csbase.logic.server.ServerInfo;
import csbase.logic.server.ServerInfoAddEvent;
import csbase.logic.server.ServerInfoData;
import csbase.logic.server.ServerInfoEvent;
import csbase.logic.server.ServerInfoEventType;
import csbase.logic.server.ServerInfoModifyEvent;
import csbase.logic.server.ServerInfoRemoveEvent;
import csbase.remote.ClientRemoteLocator;
import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;
import java.rmi.RemoteException;
import java.security.cert.Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.SortedSet;

public final class ServerInfoManager {
    private static ServerInfoManager instance;
    private ServerInfoManagerState state = this.canEnable() ? ENABLED_STATE : DISABLED_STATE;
    private static final ServerInfoManagerEnabledState ENABLED_STATE;
    private static final ServerInfoManagerDisabledState DISABLED_STATE;

    private ServerInfoManager() {
    }

    private boolean canEnable() {
        return ClientRemoteLocator.serverService != null && User.getLoggedUser().isAdmin();
    }

    public static ServerInfoManager getInstance() {
        if (instance == null) {
            instance = new ServerInfoManager();
        }
        return instance;
    }

    public void start() throws RemoteException {
        this.state.start();
    }

    public void stop() {
        this.state.stop();
    }

    public SortedSet<ServerInfo> getServersInfos() throws RemoteException {
        return this.state.getServersInfos();
    }

    public boolean addServerInfo(ServerInfoData localServer) throws RemoteException {
        return this.state.addServerInfo(localServer);
    }

    public boolean addCertificate(String serverName, Certificate cert) throws RemoteException {
        return this.state.addCertificate(serverName, cert);
    }

    public void removeCertificate(String serverName) throws RemoteException {
        this.state.removeCertificate(serverName);
    }

    public boolean modifyServerInfo(ServerInfo oldLocalServer, ServerInfoData newLocalServer) throws RemoteException {
        return this.state.modifyServerInfo(oldLocalServer, newLocalServer);
    }

    public void removeServerInfo(ServerInfo localServer) throws RemoteException {
        this.state.removeServerInfo(localServer);
    }

    public void addServerInfoManagerListener(ServerInfoManagerListener listener) {
        this.state.addServerInfoManagerListener(listener);
    }

    public void removeServerInfoManagerListener(ServerInfoManagerListener listener) {
        this.state.removeServerInfoManagerListener(listener);
    }

    public boolean isEnabled() {
        return this.state.equals(ENABLED_STATE);
    }

    static {
        ENABLED_STATE = new ServerInfoManagerEnabledState();
        DISABLED_STATE = new ServerInfoManagerDisabledState();
        RestartManager.getInstance().addListener(new RestartListener(){

            public void restart() {
                instance = null;
            }
        });
    }

    private static final class ServerInfoManagerEnabledState
    implements ServerInfoManagerState,
    Observer {
        private List<ServerInfoManagerListener> listenerList = new LinkedList<ServerInfoManagerListener>();
        private ServerServiceRemoteObserver remoteObserver;

        ServerInfoManagerEnabledState() {
        }

        private boolean wasStarted() {
            return this.remoteObserver != null;
        }

        @Override
        public void start() throws RemoteException {
            if (this.wasStarted()) {
                throw new IllegalStateException("Tentativa de iniciar o gerenciador de informa\u00e7\u00f5es de servidores locais que j\u00e1 foi iniciado.");
            }
            this.remoteObserver = new ServerServiceRemoteObserver();
            this.remoteObserver.addObserver(this);
            this.remoteObserver.install();
        }

        @Override
        public void stop() {
            if (!this.wasStarted()) {
                throw new IllegalStateException("Tentativa de para o gerenciador de informa\u00e7\u00f5es de servidores locais sem ter sido iniciado.");
            }
            this.remoteObserver.deleteObserver(this);
            this.remoteObserver = null;
        }

        @Override
        public SortedSet<ServerInfo> getServersInfos() throws RemoteException {
            return ClientRemoteLocator.serverService.getServersInfos();
        }

        @Override
        public boolean addServerInfo(ServerInfoData localServer) throws RemoteException {
            return ClientRemoteLocator.serverService.addServerInfo(localServer);
        }

        @Override
        public boolean modifyServerInfo(ServerInfo oldLocalServer, ServerInfoData newLocalServer) throws RemoteException {
            return ClientRemoteLocator.serverService.modifyServerInfo(oldLocalServer, newLocalServer);
        }

        @Override
        public void removeServerInfo(ServerInfo localServer) throws RemoteException {
            ClientRemoteLocator.serverService.removeServerInfo(localServer);
        }

        @Override
        public void addServerInfoManagerListener(ServerInfoManagerListener listener) {
            if (!this.wasStarted()) {
                throw new IllegalStateException("Tentativa de adicionar ouvinte ao gerenciador de informa\u00e7\u00f5es de servidores locais que n\u00e3o foi iniciado.");
            }
            this.listenerList.add(listener);
        }

        @Override
        public void removeServerInfoManagerListener(ServerInfoManagerListener listener) {
            if (!this.wasStarted()) {
                throw new IllegalStateException("Tentativa de remover ouvinte do gerenciador de informa\u00e7\u00f5es de servidores locais que n\u00e3o foi iniciado.");
            }
            this.listenerList.remove(listener);
        }

        private void handleEvent(ServerInfoAddEvent event) {
            this.fireWasAddedLocalServer(event.getServerInfo());
        }

        private void handleEvent(ServerInfoModifyEvent event) {
            this.fireWasModifiedLocalServer(event.getOldServerInfo(), event.getNewServerInfo());
        }

        private void handleEvent(ServerInfoRemoveEvent event) {
            this.fireWasRemovedLocalServer(event.getServerInfo());
        }

        private void fireWasAddedLocalServer(ServerInfo localServer) {
            for (ServerInfoManagerListener listener : this.listenerList) {
                listener.wasAddedServerInfo(localServer);
            }
        }

        private void fireWasModifiedLocalServer(ServerInfo oldLocalServer, ServerInfo newLocalServer) {
            for (ServerInfoManagerListener listener : this.listenerList) {
                listener.wasModifiedServerInfo(oldLocalServer, newLocalServer);
            }
        }

        private void fireWasRemovedLocalServer(ServerInfo localServer) {
            for (ServerInfoManagerListener listener : this.listenerList) {
                listener.wasRemovedServerInfo(localServer);
            }
        }

        @Override
        public void update(Observable o, Object arg) {
            ServerInfoEvent localServerEvent = (ServerInfoEvent)arg;
            if (localServerEvent.getType().equals((Object)ServerInfoEventType.ADD)) {
                this.handleEvent((ServerInfoAddEvent)localServerEvent);
            } else if (localServerEvent.getType().equals((Object)ServerInfoEventType.MODIFY)) {
                this.handleEvent((ServerInfoModifyEvent)localServerEvent);
            } else if (localServerEvent.getType().equals((Object)ServerInfoEventType.REMOVE)) {
                this.handleEvent((ServerInfoRemoveEvent)localServerEvent);
            } else {
                throw new IllegalStateException("Recebido um evento de um tipo desconhecido: " + localServerEvent.getType());
            }
        }

        @Override
        public boolean addCertificate(String serverName, Certificate cert) throws RemoteException {
            return ClientRemoteLocator.serverService.addCert(serverName, cert);
        }

        @Override
        public void removeCertificate(String serverName) throws RemoteException {
            ClientRemoteLocator.serverService.removeCert(serverName);
        }
    }

    private static final class ServerInfoManagerDisabledState
    implements ServerInfoManagerState {
        private ServerInfoManagerDisabledState() {
        }

        @Override
        public void start() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void stop() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<ServerInfo> getServersInfos() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addServerInfo(ServerInfoData localServer) throws RemoteException, UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean modifyServerInfo(ServerInfo oldLocalServer, ServerInfoData newLocalServer) throws RemoteException, UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeServerInfo(ServerInfo localServer) throws RemoteException, UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addServerInfoManagerListener(ServerInfoManagerListener listener) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeServerInfoManagerListener(ServerInfoManagerListener listener) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addCertificate(String serverName, Certificate cert) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeCertificate(String serverName) throws RemoteException, UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    private static interface ServerInfoManagerState {
        public void start() throws RemoteException, UnsupportedOperationException;

        public void stop() throws UnsupportedOperationException;

        public SortedSet<ServerInfo> getServersInfos() throws RemoteException, UnsupportedOperationException;

        public boolean addServerInfo(ServerInfoData var1) throws RemoteException, UnsupportedOperationException;

        public boolean modifyServerInfo(ServerInfo var1, ServerInfoData var2) throws RemoteException, UnsupportedOperationException;

        public void removeServerInfo(ServerInfo var1) throws RemoteException, UnsupportedOperationException;

        public void addServerInfoManagerListener(ServerInfoManagerListener var1) throws UnsupportedOperationException;

        public void removeServerInfoManagerListener(ServerInfoManagerListener var1) throws UnsupportedOperationException;

        public boolean addCertificate(String var1, Certificate var2) throws RemoteException, UnsupportedOperationException;

        public void removeCertificate(String var1) throws RemoteException, UnsupportedOperationException;
    }
}

