/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.table;

import csbase.client.util.table.CellView;
import csbase.client.util.table.CellViewListener;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.UIManager;
import javax.swing.border.Border;

public abstract class AbstractCellView
implements CellView {
    private static final Color ERROR_BORDER_COLOR = Color.RED;
    private static final int ERROR_BORDER_THICKNESS = 2;
    boolean isEditing;
    private List<CellViewListener> listeners = new LinkedList<CellViewListener>();

    protected AbstractCellView() {
        this.addCellViewListener(new CellViewListener(){

            @Override
            public void valueWasChanged(CellView cellView) {
                cellView.validate();
            }
        });
    }

    @Override
    public final void addCellViewListener(CellViewListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    @Override
    public String getTip() {
        return null;
    }

    @Override
    public final boolean isEditing() {
        return this.isEditing;
    }

    @Override
    public final boolean removeCellViewListener(CellViewListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        return this.listeners.remove(listener);
    }

    @Override
    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("O par\u00e2metro backgroundColor est\u00e1 nulo.");
        }
        this.getView().setBackground(backgroundColor);
    }

    @Override
    public void setFocus(boolean hasFocus) {
        if (this.isValid()) {
            Border border = hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : null;
            this.setBorder(border);
        }
    }

    @Override
    public void setForegroundColor(Color foregroundColor) {
        if (foregroundColor == null) {
            throw new IllegalArgumentException("O par\u00e2metro foregroundColor est\u00e1 nulo.");
        }
        this.getView().setForeground(foregroundColor);
    }

    @Override
    public final boolean setValue(Object value) {
        if (value == null && this.getValue() == null) {
            return false;
        }
        if (value != null && value.equals(this.getValue())) {
            return false;
        }
        this.keepValue(value);
        this.fireValueWasChanged();
        return true;
    }

    @Override
    public void startEditing() {
        this.isEditing = true;
    }

    @Override
    public void stopEditing() {
        this.isEditing = false;
    }

    @Override
    public final boolean validate() {
        String validationErrorMessage = this.getValidationErrorMessage();
        if (validationErrorMessage != null) {
            this.getView().setToolTipText(validationErrorMessage);
            Border border = BorderFactory.createLineBorder(ERROR_BORDER_COLOR, 2);
            this.setBorder(border);
            return false;
        }
        this.getView().setToolTipText(this.getTip());
        this.setBorder(null);
        return true;
    }

    protected final void fireValueWasChanged() {
        for (CellViewListener listener : this.listeners) {
            listener.valueWasChanged(this);
        }
    }

    protected String getValidationErrorMessage() {
        return null;
    }

    protected abstract void keepValue(Object var1);

    protected void setBorder(Border border) {
        this.getView().setBorder(border);
    }

    private boolean isValid() {
        return this.getValidationErrorMessage() == null;
    }
}

