/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.Application;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmVersionInfoPanel;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.applications.algorithmsmanager.versiontree.AbstractFileInfoNode;
import csbase.client.applications.algorithmsmanager.versiontree.ConfigurationFileNode;
import csbase.client.applications.algorithmsmanager.versiontree.DocumentationFileNode;
import csbase.client.applications.algorithmsmanager.versiontree.ExecutableFileNode;
import csbase.client.applications.algorithmsmanager.versiontree.ReleaseNotesFileNode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionNodeInterface;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTreeNode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTreeRootNode;
import csbase.client.applications.algorithmsmanager.versiontree.actions.CommonAlgoFileRenameAction;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmInfo;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tecgraf.javautils.gui.GBC;

public class VersionTreeView {
    private AlgorithmVersionInfoPanel versionInfoPanel;
    private VersionTree versionTree;
    private JPanel versionTreePanel;
    private VersionTreeCellEditor editor;
    private boolean infoAlreadyUpdated;
    protected boolean renameEnabled;
    private int currentVersionRow;
    public static String ROOT_NAME;

    public VersionTreeView(AlgorithmVersionInfoPanel versionInfoPanel, AlgorithmInfo algorithmInfo) {
        this.versionInfoPanel = versionInfoPanel;
        this.currentVersionRow = -1;
        ROOT_NAME = this.getApplication().getString("VersionTreeView.root.label.versions");
        this.getVersionTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                Object node = e.getPath().getLastPathComponent();
                TreeNode treeNode = (TreeNode)node;
                VersionTreeView.this.initVersionSelection(treeNode);
            }
        });
    }

    private Application getApplication() {
        return this.versionInfoPanel.getApplication();
    }

    private void initVersionSelection(TreeNode treeNode) {
        if (this.infoAlreadyUpdated) {
            this.versionInfoPanel.verifyAndChangeButtonsState();
        } else {
            if (this.changedSelectedVersion()) {
                if (!this.versionInfoPanel.confirmSelectionChanged()) {
                    this.setCurrentNode();
                    return;
                }
                this.currentVersionRow = this.getSelectedRow();
            }
            VersionTreeNode versionNode = this.getVersionNode(treeNode);
            this.versionInfoPanel.initVersionNodeEdition(versionNode);
        }
        this.versionInfoPanel.enableVersionEditPanel(treeNode instanceof VersionTreeNode);
    }

    public JPanel getVersionTreePanel() {
        if (this.versionTreePanel == null) {
            this.versionTreePanel = new JPanel(new GridBagLayout());
            this.versionTreePanel.add((Component)new JScrollPane(this.getVersionTree()), new GBC(0, 0).both().west().insets(0, 0, 0, 0));
        }
        return this.versionTreePanel;
    }

    public VersionNodeInterface getFirstSelectedNode() {
        VersionNodeInterface node = null;
        int selectedCount = this.versionTree.getSelectionCount();
        if (selectedCount == 1) {
            Object selectionPath = this.versionTree.getSelectionPath().getLastPathComponent();
            node = (VersionNodeInterface)selectionPath;
        }
        return node;
    }

    public int getSelectedRow() {
        int[] selectionRows = this.versionTree.getSelectionRows();
        if (selectionRows != null && selectionRows.length > 0) {
            return selectionRows[0];
        }
        return 0;
    }

    public List<VersionNodeInterface> getSelectedDataList() {
        ArrayList<VersionNodeInterface> selectedDataList = new ArrayList<VersionNodeInterface>();
        TreePath[] selectionPaths = this.versionTree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath treePath : selectionPaths) {
                Object treeNode = treePath.getLastPathComponent();
                if (!(treeNode instanceof VersionNodeInterface)) continue;
                selectedDataList.add((VersionNodeInterface)treeNode);
            }
        }
        return selectedDataList;
    }

    public List<VersionNodeInterface> getFullPathSelectedNode() {
        ArrayList<VersionNodeInterface> fullPath = new ArrayList<VersionNodeInterface>();
        int selectedCount = this.versionTree.getSelectionCount();
        if (selectedCount == 1) {
            Object[] paths = this.versionTree.getSelectionPath().getPath();
            VersionTreeRootNode rootNode = (VersionTreeRootNode)paths[0];
            fullPath.add(rootNode);
            for (Object path : paths) {
                if (!(path instanceof VersionTreeNode)) continue;
                VersionTreeNode node = (VersionTreeNode)path;
                fullPath.add(node);
            }
        }
        return fullPath;
    }

    public VersionTreeRootNode getRootNode() {
        TreePath rootPath = this.versionTree.getPathForRow(0);
        Object treeNode = rootPath.getLastPathComponent();
        if (treeNode instanceof VersionTreeRootNode) {
            return (VersionTreeRootNode)treeNode;
        }
        return null;
    }

    protected VersionNodeInterface getNode(TreePath path) {
        Object lastPath;
        if (path != null && VersionNodeInterface.class.isAssignableFrom((lastPath = path.getLastPathComponent()).getClass())) {
            return (VersionNodeInterface)lastPath;
        }
        return null;
    }

    public boolean isRootNodeSelected() {
        return this.versionTree.isRowSelected(0);
    }

    public int getSelectionCount() {
        return this.versionTree.getSelectionCount();
    }

    public VersionTree getVersionTree() {
        if (this.versionTree == null) {
            AlgorithmListItem selectedAlgorithmItem = this.versionInfoPanel.getSelectedAlgorithmItem();
            AlgorithmInfo algoInfo = selectedAlgorithmItem == null ? null : selectedAlgorithmItem.getItem();
            this.versionTree = new VersionTree(this.getApplication().getApplicationFrame(), algoInfo);
            this.editor = new VersionTreeCellEditor(new CommonAlgoFileRenameAction(this.versionTree), this.versionTree);
            this.versionTree.setCellEditor(this.editor);
            this.enableRenameAction(true);
        }
        return this.versionTree;
    }

    public void initializeVersionTree(AlgorithmInfo algoInfo) {
        this.getVersionTree().initializeTree(algoInfo);
        this.getVersionTreePanel().revalidate();
    }

    public VersionTreeNode getVersionNode(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        if (treeNode instanceof VersionTreeRootNode) {
            return null;
        }
        if (treeNode instanceof VersionTreeNode) {
            return (VersionTreeNode)treeNode;
        }
        TreeNode parent = treeNode.getParent();
        return this.getVersionNode(parent);
    }

    private boolean changedSelectedVersion() {
        return this.currentVersionRow != this.getSelectedRow();
    }

    private void selectRootNode() {
        this.versionTree.setSelectionRow(0);
    }

    private void selectNode(int nodeRow) {
        this.versionTree.selectNode(nodeRow);
    }

    private void selectCurrentNode() {
        if (this.currentVersionRow == -1) {
            this.selectRootNode();
        }
        this.selectNode(this.currentVersionRow);
    }

    public void setCurrentNode() {
        this.infoAlreadyUpdated = true;
        this.selectCurrentNode();
        this.infoAlreadyUpdated = false;
    }

    public void handleAlgorithmUpdated(AlgorithmInfo algoInfo) {
        this.infoAlreadyUpdated = true;
        this.versionTree.replaceAlgoNode(algoInfo);
        this.infoAlreadyUpdated = false;
        this.selectCurrentNode();
    }

    public void enableRenameAction(boolean enable) {
        if (enable) {
            this.versionTree.setEditable(true);
            this.versionTree.setCellEditor(this.editor);
        } else {
            this.versionTree.setEditable(false);
            this.versionTree.setCellEditor(null);
        }
        this.renameEnabled = enable;
    }

    private class VersionTreeCellEditor
    extends DefaultTreeCellEditor {
        @Override
        public boolean isCellEditable(EventObject event) {
            VersionTree tree = VersionTreeView.this.getVersionTree();
            TreePath path = tree.getSelectionPath();
            if (path == null) {
                return false;
            }
            return super.isCellEditable(event);
        }

        VersionTreeCellEditor(CommonAlgoFileRenameAction action, JTree tree) {
            this(action, tree, new DefaultTreeCellRenderer(), null);
        }

        VersionTreeCellEditor(final CommonAlgoFileRenameAction action, final JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
            super(tree, renderer, editor);
            this.addCellEditorListener(new CellEditorListener(){

                private void rename() {
                    TreePath path = tree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    Object component = path.getLastPathComponent();
                    if (AbstractFileInfoNode.class.isAssignableFrom(component.getClass())) {
                        String newName;
                        AbstractFileInfoNode node = (AbstractFileInfoNode)component;
                        FileInfo fileInfo = node.getFile();
                        String oldName = fileInfo.getName();
                        if (oldName.equals(newName = (String)VersionTreeCellEditor.this.getCellEditorValue())) {
                            return;
                        }
                        if (ConfigurationFileNode.class.isAssignableFrom(component.getClass())) {
                            ConfigurationFileNode confFileNode = (ConfigurationFileNode)component;
                            action.renameFile(confFileNode.getVersion(), confFileNode.getType(), fileInfo, newName);
                        } else if (DocumentationFileNode.class.isAssignableFrom(component.getClass())) {
                            DocumentationFileNode docFileNode = (DocumentationFileNode)component;
                            action.renameFile(docFileNode.getVersion(), docFileNode.getType(), fileInfo, newName);
                        } else if (ReleaseNotesFileNode.class.isAssignableFrom(component.getClass())) {
                            ReleaseNotesFileNode releaseNotesFileNode = (ReleaseNotesFileNode)component;
                            action.renameFile(releaseNotesFileNode.getVersion(), releaseNotesFileNode.getType(), fileInfo, newName);
                        } else if (ExecutableFileNode.class.isAssignableFrom(component.getClass())) {
                            ExecutableFileNode execFileNode = (ExecutableFileNode)component;
                            action.renameExecFile(execFileNode.getVersion(), execFileNode.getPlatform(), fileInfo, newName);
                        }
                    }
                }

                @Override
                public void editingCanceled(ChangeEvent event) {
                    this.rename();
                }

                @Override
                public void editingStopped(ChangeEvent event) {
                    this.rename();
                }
            });
        }

        @Override
        protected TreeCellEditor createTreeCellEditor() {
            Border aBorder = UIManager.getBorder("Tree.editorBorder");
            DefaultTreeCellEditor.DefaultTextField textField = new DefaultTreeCellEditor.DefaultTextField(aBorder){

                @Override
                public void selectAll() {
                    Document doc = this.getDocument();
                    if (doc != null) {
                        this.setCaretPosition(0);
                        this.moveCaretPosition(this.getLastPositionBeforeDot());
                    }
                }

                private int getLastPositionBeforeDot() {
                    String text = this.getText();
                    int pos = text.lastIndexOf(46);
                    if (pos == -1 || pos == 0) {
                        return text.length();
                    }
                    return pos;
                }
            };
            return new DefaultCellEditor(textField);
        }
    }
}

