/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandviewer;

import csbase.client.algorithms.commands.newview.CommandViewFactory;
import csbase.client.algorithms.commands.newview.NewCommandViewUtils;
import csbase.client.algorithms.commands.tasks.GetCommandTask;
import csbase.client.algorithms.commands.view.TabType;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommandInfo;
import csbase.logic.CommonClientProject;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class CommandViewer
extends ApplicationType {
    private static final String OPEN_COMMAND_MSG = "OPEN_COMMAND";

    public CommandViewer(String id) {
        super(id);
    }

    @Override
    public void killApplication() {
        ApplicationManager manager = ApplicationManager.getInstance();
        manager.notifyDeath(this);
    }

    @Override
    protected boolean userCanKillApplication() {
        return true;
    }

    @Override
    public void startApplication() throws ApplicationException {
    }

    @Override
    public void finishApplication() {
    }

    @Override
    public void sendMessage(String name, Object value, String senderId) {
        if (name == null) {
            throw new IllegalArgumentException("O par\u00e2metro name n\u00e3o pode ser nulo.");
        }
        if (value == null) {
            throw new IllegalArgumentException("O par\u00e2metro value n\u00e3o pode ser nulo.");
        }
        if (name.equals(OPEN_COMMAND_MSG) && value instanceof String) {
            this.showCommand((String)value);
        }
        this.killApplication();
    }

    private void showCommand(String commandId) {
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        final DesktopComponentFrame frame = desktopFrame.getDesktopFrame();
        CommonClientProject project = desktopFrame.getProject();
        final CommandInfo command = GetCommandTask.executeTask(commandId, project.getId(), null);
        if (command != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        CommandViewFactory.showCommandView(command, frame, NewCommandViewUtils.getNewTabType(TabType.PARAMETERS));
                    }
                    catch (Exception e) {
                        StandardErrorDialogs.showErrorDialog((Window)frame, CommandViewer.this.getName(), (Throwable)e);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }
}

