/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph.actions;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddGraphPopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.graph.actions.GraphAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class BypassAction
extends GraphAction {
    protected BypassAction(Graph graph) {
        super(graph, BypassAction.getName(graph), BypassAction.getIcon(graph));
        this.setEnabled(graph.hasSelectedElements());
    }

    private static String getName(Graph graph) {
        String suffix = BypassAction.areBeingBypassed(graph.getSelectedNodes()) ? ".undo_bypass" : ".bypass";
        return BypassAction.class.getName() + suffix;
    }

    private static ImageIcon getIcon(Graph graph) {
        if (BypassAction.areBeingBypassed(graph.getSelectedNodes())) {
            return ApplicationImages.ICON_TURNON_16;
        }
        return ApplicationImages.ICON_TURNOFF_16;
    }

    private static boolean areBeingBypassed(Collection<GraphNode> nodes) {
        for (GraphNode node : nodes) {
            if (node.canBeBypassed() && node.isBypassed()) continue;
            return false;
        }
        return true;
    }

    private static boolean canBeBypassed(Collection<GraphNode> nodes) {
        for (GraphNode node : nodes) {
            if (node.canBeBypassed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Graph graph = this.getGraph();
        Set<GraphNode> selectedElements = graph.getSelectedNodes();
        boolean canBeBypassed = BypassAction.canBeBypassed(selectedElements);
        boolean areBypassed = BypassAction.areBeingBypassed(selectedElements);
        if (canBeBypassed || areBypassed) {
            boolean bypassActionStatus = true;
            HashMap<GraphNode, Boolean> memento = new HashMap<GraphNode, Boolean>();
            for (GraphElement graphElement : selectedElements) {
                GraphNode node = (GraphNode)graphElement;
                memento.put(node, node.isBypassed());
                bypassActionStatus = node.setBypassed(!areBypassed);
                if (bypassActionStatus) continue;
                this.undoBypass(memento);
                break;
            }
        } else {
            StandardDialogs.showErrorDialog((Component)graph.getParentWindow(), (String)LNG.get((String)"csbase.client.applications.flowapplication.graph.actions.BypassAction.error_title"), (String)LNG.get((String)"csbase.client.applications.flowapplication.graph.actions.BypassAction.error_msg"));
        }
    }

    private void undoBypass(Map<GraphNode, Boolean> memento) {
        for (GraphNode node : memento.keySet()) {
            node.setBypassed(memento.get(node));
        }
    }

    public static WorkspaceFilter createFilter(Workspace workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException("O par\u00e2metro workspace est\u00e1 nulo.");
        }
        return new AddGraphPopupActionFilter(workspace){

            @Override
            protected GraphAction createAction(Graph graph) {
                if (!graph.getSelectedNodes().isEmpty()) {
                    return new BypassAction(graph);
                }
                return null;
            }
        };
    }
}

