/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui.log.tab;

import csbase.client.Client;
import csbase.client.ClientLocalFile;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.event.EventListener;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.client.util.gui.log.LogPanelReloader;
import csbase.client.util.gui.log.LogPanelTextArea;
import csbase.client.util.gui.log.tab.AbstractLogTab;
import csbase.client.util.iostring.TextReader;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StatusBar;

public class ConsolidatedLogTab
extends AbstractLogTab {
    private final Map<ClientProjectFile, LogPanelTextArea> panels = new HashMap<ClientProjectFile, LogPanelTextArea>();
    private JPanel mainPanel = new JPanel();
    private ClientLocalFile lastSelectedDir;
    private JScrollPane scrollPane;

    public ConsolidatedLogTab(String title, Set<ClientProjectFile> files, StatusBar statusBar, Window owner, boolean autoReload) {
        super(title, statusBar, owner, autoReload);
        this.mainPanel.setLayout(new GridBagLayout());
        this.initUI(files);
    }

    private void initUI(Set<ClientProjectFile> files) {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        int i = 0;
        for (ClientProjectFile file : files) {
            LogPanelTextArea textArea = new LogPanelTextArea(this, false, "[" + file.getName() + "]");
            textArea.setPrefix(0L);
            JSeparator separator = new JSeparator();
            this.panels.put(file, textArea);
            internalPanel.add((Component)separator, new GBC(0, i++).horizontal());
            internalPanel.add((Component)textArea, new GBC(0, i++).both());
        }
        JToolBar toolbar = this.createToolBar();
        this.mainPanel.add((Component)toolbar, new GBC(0, 0).horizontal());
        this.scrollPane = new JScrollPane(internalPanel);
        int mode = 22;
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.mainPanel.add((Component)this.scrollPane, new GBC(0, 1).both());
        this.reload();
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        final JToggleButton autoReloadButton = new JToggleButton();
        autoReloadButton.setAction(new ReloadAction());
        autoReloadButton.setSelected(this.reloader.isRunning());
        autoReloadButton.setToolTipText(LNG.get((String)(ConsolidatedLogTab.class.getSimpleName() + ".button.reload.tooltip")));
        this.reloader.addStatusChangedEventListener(new EventListener<LogPanelReloader.StatusChangedEvent>(){

            @Override
            public void eventFired(LogPanelReloader.StatusChangedEvent event) {
                autoReloadButton.setSelected(event.isRunning());
            }
        });
        toolBar.add(autoReloadButton);
        toolBar.addSeparator();
        JButton exportButton = new JButton();
        exportButton.setAction(new ExportAction());
        exportButton.setToolTipText(LNG.get((String)(ConsolidatedLogTab.class.getSimpleName() + ".button.export.tooltip")));
        toolBar.add(exportButton);
        return toolBar;
    }

    @Override
    public void reload() {
        RemoteTask<Map<ClientProjectFile, String>> reloadTask = new RemoteTask<Map<ClientProjectFile, String>>(){

            protected void performTask() throws Exception {
                HashMap<ClientProjectFile, String> result = new HashMap<ClientProjectFile, String>();
                for (ClientProjectFile file : ConsolidatedLogTab.this.panels.keySet()) {
                    String fileContent = ConsolidatedLogTab.this.readFile(file);
                    result.put(file, fileContent);
                }
                this.setResult(result);
            }

            protected void afterTaskUI() {
                Exception error = this.getError();
                if (error != null) {
                    String errorMsg = LNG.get((String)(ConsolidatedLogTab.class.getSimpleName() + ".error.reload.failed"));
                    ConsolidatedLogTab.this.statusBar.setError(errorMsg);
                } else {
                    Map result = (Map)this.getResult();
                    if (result != null) {
                        for (Map.Entry entry : result.entrySet()) {
                            LogPanelTextArea logPanelTextArea = (LogPanelTextArea)ConsolidatedLogTab.this.panels.get(entry.getKey());
                            logPanelTextArea.setText((String)entry.getValue());
                        }
                        ConsolidatedLogTab.this.scrollPane.revalidate();
                    }
                }
            }
        };
        String title = LNG.get((String)(ConsolidatedLogTab.class.getSimpleName() + ".title.reload.task"), (Object[])new Object[]{this.getTitle()});
        String message = LNG.get((String)(ConsolidatedLogTab.class.getSimpleName() + ".message.reload.task"));
        reloadTask.execute(this.getOwner(), title, message);
    }

    private String readFile(ClientProjectFile file) {
        String content = "";
        try {
            Client client = Client.getInstance();
            Charset charset = client.getSystemDefaultCharset();
            content = TextReader.readAllWithoutTask((ClientFile)file, charset, null);
        }
        catch (Exception ex) {
            String errorMsg = LNG.get((String)(ConsolidatedLogTab.class.getSimpleName() + ".error.log.read.failed"), (Object[])new Object[]{file.getName()});
            content = " [" + errorMsg + "]\n";
        }
        return content;
    }

    @Override
    public Component getMainComponent() {
        return this.mainPanel;
    }

    private final class ExportTask
    extends RemoteTask<Void> {
        private final ClientFile file;

        private ExportTask(ClientFile file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void performTask() throws Exception {
            OutputStream outputStream = null;
            try {
                LinkedHashSet<ClientProjectFile> files = new LinkedHashSet<ClientProjectFile>(ConsolidatedLogTab.this.panels.keySet());
                String fileContents = this.readFiles(files);
                outputStream = this.file.getOutputStream();
                outputStream.write(fileContents.getBytes());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        public String readFiles(Set<ClientProjectFile> files) throws IOException {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            if (files != null) {
                for (ClientProjectFile clientFile : files) {
                    String content = ConsolidatedLogTab.this.readFile(clientFile);
                    if (content == null) continue;
                    printWriter.print("\n");
                    printWriter.printf("---- %s ----", clientFile.getName());
                    printWriter.print("\n");
                    printWriter.print(content);
                }
            }
            return writer.getBuffer().toString();
        }
    }

    private final class ExportAction
    extends AbstractAction {
        private ExportAction() {
            super(null, ApplicationImages.ICON_EXPORT_16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<String> fileCodes = new ArrayList<String>();
            fileCodes.add("LOG");
            fileCodes.add("TEXT");
            String title = LNG.get((String)(ConsolidatedLogTab.class.getSimpleName() + ".title.export.task"), (Object[])new Object[]{ConsolidatedLogTab.this.getTitle()});
            Window owner = ConsolidatedLogTab.this.getOwner();
            ClientLocalFile file = ClientLocalFileChooserUtil.browseSingleFileInSaveMode(owner, fileCodes, "LOG", title, true, ConsolidatedLogTab.this.lastSelectedDir);
            if (file != null) {
                ConsolidatedLogTab.this.lastSelectedDir = (ClientLocalFile)file.getParent();
                ExportTask task = new ExportTask(file);
                String message = LNG.get((String)(ConsolidatedLogTab.class.getSimpleName() + ".message.export.task"));
                if (!task.execute(owner, title, message)) {
                    String key = ConsolidatedLogTab.class.getSimpleName() + ".error.export.task";
                    String error = LNG.get((String)key);
                    ConsolidatedLogTab.this.statusBar.setError(error, 10);
                } else {
                    String key = ConsolidatedLogTab.class.getSimpleName() + ".message.confirm.export.task";
                    String success = LNG.get((String)key, (Object[])new Object[]{"'" + file.getName() + "'"});
                    ConsolidatedLogTab.this.statusBar.setInfo(success, 10);
                }
            }
        }
    }

    private final class ReloadAction
    extends AbstractAction {
        private ReloadAction() {
            super(null, ApplicationImages.ICON_REFRESH_16);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ConsolidatedLogTab.this.reloader.isRunning()) {
                ConsolidatedLogTab.this.reloader.stop();
            } else {
                ConsolidatedLogTab.this.reloader.start();
            }
        }
    }
}

