/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.ParameterLoaderView;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import java.awt.Window;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import tecgraf.javautils.core.lng.LNG;

public class ParameterLoaderTask
extends RemoteTask<String> {
    private Window window;
    private ParameterLoaderView parameter;
    private ClientProjectFile file = null;

    public ParameterLoaderTask(Window window, ParameterLoaderView parameter) {
        this.window = window;
        this.parameter = parameter;
    }

    protected void cancelTask() {
        super.cancelTask();
        try {
            this.file.remove();
        }
        catch (Exception e) {
            StandardErrorDialogs.showExceptionDialog(this.window, LNG.get((String)"ParameterLoaderView.error.title"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performTask() throws Exception {
        String outputExtractFileName = this.parameter.getOutputExtractFileName();
        CommonClientProject currentProject = DesktopFrame.getInstance().getProject();
        ClientProjectFile rootFile = currentProject.getRoot();
        this.file = rootFile.getChild(outputExtractFileName);
        if (this.file == null) {
            throw new FileNotFoundException(String.format(LNG.get((String)"ParameterLoaderView.file_not_found.error"), outputExtractFileName));
        }
        try (InputStreamReader reader = new InputStreamReader(this.file.getInputStream());){
            StringBuilder fileContents = new StringBuilder();
            int character = ((Reader)reader).read();
            while (character != -1) {
                fileContents.append((char)character);
                character = ((Reader)reader).read();
            }
            this.setResult(fileContents.toString());
        }
        finally {
            this.file.remove();
        }
    }

    @Override
    protected void handleError(Exception error) {
        StandardErrorDialogs.showExceptionDialog(this.window, LNG.get((String)"ParameterLoaderView.error.title"), error);
    }
}

