/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms;

import csbase.client.Client;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.DesktopWindowInterface;
import csbase.client.desktop.Task;
import csbase.client.util.ClientUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

public class FileViewerDialog
extends JDialog
implements DesktopWindowInterface {
    private JTextArea textArea;
    private JPanel textAreaPanel;
    private JScrollPane textScrollPane;
    private float fontSizePercent = 100.0f;
    private static final int ORIGINAL_FONT_SIZE = 12;
    private static final Font FIXED_SIZE_FONT = new Font("Monospaced", 0, 12);
    private InputStream fileInputStream;

    public FileViewerDialog(Window owner, String title, InputStream fileInputStream) {
        super(owner, title);
        this.fileInputStream = fileInputStream;
        this.setSize(new Dimension(800, 600));
        this.setLocationRelativeTo(owner);
        this.getContentPane().add(this.buildPanel());
        this.loadFile();
    }

    private JPanel buildPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.buildTextArea(), "Center");
        panel.add((Component)this.buildButtonsPanel(), "South");
        return panel;
    }

    private JPanel buildTextArea() {
        this.textAreaPanel = new JPanel(new GridBagLayout());
        this.textArea = new JTextArea();
        this.textArea.setEditable(true);
        this.textArea.setFont(FIXED_SIZE_FONT);
        this.textArea.setTabSize(4);
        ClientUtilities.applyUndoRedoActions(this.textArea);
        this.textArea.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if ((e.getModifiersEx() & 0x80) != 0) {
                    if (e.getScrollType() == 0) {
                        int totalScrollAmount = e.getUnitsToScroll();
                        FileViewerDialog.this.modifyFontSize(totalScrollAmount);
                    }
                } else {
                    FileViewerDialog.this.textScrollPane.getMouseWheelListeners()[0].mouseWheelMoved(e);
                }
            }
        });
        this.textArea.setEditable(false);
        this.textScrollPane = new JScrollPane(this.textArea);
        this.textScrollPane.setVerticalScrollBarPolicy(22);
        Dimension scrDim = new Dimension(600, 400);
        this.textScrollPane.setSize(scrDim);
        this.textScrollPane.setPreferredSize(scrDim);
        this.textScrollPane.setMinimumSize(scrDim);
        this.textAreaPanel.add((Component)this.textScrollPane, new GBC(0, 0).insets(0, 1, 0, 0).both());
        return this.textAreaPanel;
    }

    private JPanel buildButtonsPanel() {
        String cancelText = LNG.get((String)"FileViwerDialog.button.close");
        JButton cancelButton = new JButton(cancelText);
        cancelButton.addActionListener(e -> this.close());
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)cancelButton, new GBC(0, 0).east().insets(0, 5, 0, 0));
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        return buttonsPanel;
    }

    @Override
    public void close() {
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        if (desktopFrame != null) {
            desktopFrame.removeWindow(this);
        }
        this.dispose();
    }

    protected void modifyFontSize(int addSize) {
        this.fontSizePercent = this.fontSizePercent + (float)addSize > 200.0f ? 200.0f : (this.fontSizePercent + (float)addSize < 75.0f ? 75.0f : (this.fontSizePercent += (float)addSize));
        Font font = this.textArea.getFont();
        float newFontSize = 12.0f * (this.fontSizePercent / 100.0f);
        this.textArea.setFont(font.deriveFont(newFontSize));
    }

    private void loadFile() {
        try {
            String content = this.readFile(this.fileInputStream);
            this.textArea.setText(content);
            this.textArea.setCaretPosition(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String readFile(final InputStream stream) throws Exception {
        Task<String> task = new Task<String>(){

            protected void performTask() throws Exception {
                Client client = Client.getInstance();
                Charset currentCharset = client.getSystemDefaultCharset();
                try {
                    String result = FileViewerDialog.this.readFromInputStream(stream, currentCharset);
                    this.setResult(result);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        String msg = LNG.get((String)"FileViwerDialog.task.description");
        if (!task.execute(this, "", msg, true, false)) {
            Exception error = task.getError();
            if (error != null) {
                throw error;
            }
            return "";
        }
        String str = (String)task.getResult();
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFromInputStream(InputStream stream, Charset charset) throws IOException {
        Charset readCharset;
        if (charset == null) {
            Client client = Client.getInstance();
            readCharset = client.getSystemDefaultCharset();
        } else {
            readCharset = charset;
        }
        try (BufferedReader reader = null;){
            StringBuilder stringBuilder = new StringBuilder();
            InputStreamReader rd = new InputStreamReader(stream, readCharset);
            reader = new BufferedReader(rd);
            char[] buffer = new char[10240];
            int nbytes = reader.read(buffer);
            while (nbytes > 0) {
                stringBuilder.append(buffer, 0, nbytes);
                nbytes = reader.read(buffer);
            }
            reader.close();
            String string = stringBuilder.toString();
            return string;
        }
    }
}

