/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import tecgraf.vix.Filter;
import tecgraf.vix.TypeVS;

public final class Grid
extends Filter {
    static final int DISTANCE = 12;
    private static final Color POINT_COLOR = Color.BLACK;
    private static final Stroke STROKE = new BasicStroke(0.0f);
    private Rectangle2D bounds;
    private boolean isEnabled;

    public Grid(TypeVS vs) {
        this.changeVS(null, vs);
        this.bounds = new Rectangle();
    }

    public void callbackRepaint(Graphics2D g) {
        if (this.isEnabled) {
            g.setStroke(STROKE);
            g.setPaint(POINT_COLOR);
            int x = (int)this.bounds.getX();
            while ((double)x < this.bounds.getMaxX()) {
                int y = (int)this.bounds.getY();
                while ((double)y < this.bounds.getMaxY()) {
                    g.drawLine(x, y, x, y);
                    y += 12;
                }
                x += 12;
            }
        }
        super.callbackRepaint(g);
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setBounds2D(double x1, double y1, double x2, double y2) {
        this.bounds = new Rectangle();
        double minX = Math.floor(x1 / 12.0) * 12.0;
        double minY = Math.floor(y1 / 12.0) * 12.0;
        double maxX = Math.ceil(x2 / 12.0) * 12.0;
        double maxY = Math.ceil(y2 / 12.0) * 12.0;
        this.bounds.setFrameFromDiagonal(minX, minY, maxX, maxY);
    }

    static Rectangle2D adjustBounds(Rectangle2D bounds2D) {
        double x1 = Math.floor(bounds2D.getMinX() / 12.0) * 12.0;
        double y1 = Math.floor(bounds2D.getMinY() / 12.0) * 12.0;
        double x2 = Math.ceil(bounds2D.getMaxX() / 12.0) * 12.0;
        double y2 = Math.ceil(bounds2D.getMaxY() / 12.0) * 12.0;
        Point p1 = new Point();
        ((Point2D)p1).setLocation(x1, y1);
        Point p2 = new Point();
        ((Point2D)p2).setLocation(x2, y2);
        Rectangle newBounds = new Rectangle();
        newBounds.setFrameFromDiagonal(p1, p2);
        return newBounds;
    }

    static Point2D adjustPoint(Point2D point) {
        double newX = Math.round(point.getX() / 12.0) * 12L;
        double newY = Math.round(point.getY() / 12.0) * 12L;
        Point newPoint = new Point();
        ((Point2D)newPoint).setLocation(newX, newY);
        return newPoint;
    }

    static Rectangle2D includeMargin(Rectangle2D bounds2D) {
        double x0 = bounds2D.getMinX() - 12.0;
        double y0 = bounds2D.getMinY() - 12.0;
        double x1 = bounds2D.getMaxX() + 12.0;
        double y1 = bounds2D.getMaxY() + 12.0;
        Rectangle newBounds = new Rectangle();
        newBounds.setFrameFromDiagonal(x0, y0, x1, y1);
        return newBounds;
    }
}

