/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.imageviewer.effects;

import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.effects.AbstractEffect;
import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tecgraf.javautils.gui.GUIUtils;

public final class RGBEffect
extends AbstractEffect {
    final JSlider rSlider = new JSlider(0);
    final JSlider gSlider = new JSlider(0);
    final JSlider bSlider = new JSlider(0);
    private final int DEFAULT = 0;

    public RGBEffect(ImageViewer application) {
        super(application);
        JSlider[] sliders;
        this.rSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RGBEffect.this.updatePreview();
            }
        });
        this.gSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RGBEffect.this.updatePreview();
            }
        });
        this.bSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RGBEffect.this.updatePreview();
            }
        });
        for (JSlider slider : sliders = new JSlider[]{this.rSlider, this.bSlider, this.gSlider}) {
            int min = -100;
            int max = 100;
            int step = 10;
            slider.setMinimum(-100);
            slider.setMaximum(100);
            slider.setValue(0);
            slider.setMajorTickSpacing(10);
            slider.setPaintTicks(true);
            slider.setPaintLabels(true);
            Hashtable<Integer, JLabel> table = new Hashtable<Integer, JLabel>();
            JLabel minLabel = new JLabel("-100%");
            table.put(new Integer(-100), minLabel);
            JLabel maxLabel = new JLabel("100%");
            table.put(new Integer(100), maxLabel);
            JLabel defLabel = new JLabel("0%");
            table.put(new Integer(0), defLabel);
            slider.setLabelTable(table);
        }
    }

    @Override
    public JPanel getParameterPanel() {
        JLabel redLabel = new JLabel(this.getString("RGBEffect.red.label"));
        JLabel greenLabel = new JLabel(this.getString("RGBEffect.green.label"));
        JLabel blueLabel = new JLabel(this.getString("RGBEffect.blue.label"));
        JComponent[] rRow = new JComponent[]{redLabel, this.rSlider};
        JComponent[] gRow = new JComponent[]{greenLabel, this.gSlider};
        JComponent[] bRow = new JComponent[]{blueLabel, this.bSlider};
        JComponent[][] rows = new JComponent[][]{rRow, gRow, bRow};
        return GUIUtils.createBasicGridPanel((JComponent[][])rows);
    }

    @Override
    public BufferedImage transformImage(BufferedImage image) {
        float red = (float)this.rSlider.getValue() * 2.5f;
        float green = (float)this.gSlider.getValue() * 2.5f;
        float blue = (float)this.bSlider.getValue() * 2.5f;
        short[] lookupR = new short[256];
        short[] lookupG = new short[256];
        short[] lookupB = new short[256];
        for (int i = 0; i < 256; ++i) {
            double rd = (float)i + red;
            double gd = (float)i + green;
            double bd = (float)i + blue;
            int rv = (int)Math.round(rd);
            int gv = (int)Math.round(gd);
            int bv = (int)Math.round(bd);
            if (rv < 0) {
                rv = 0;
            }
            if (rv > 255) {
                rv = 255;
            }
            if (gv < 0) {
                gv = 0;
            }
            if (gv > 255) {
                gv = 255;
            }
            if (bv < 0) {
                bv = 0;
            }
            if (bv > 255) {
                bv = 255;
            }
            lookupR[i] = rv;
            lookupG[i] = gv;
            lookupB[i] = bv;
        }
        short[][] array = new short[][]{lookupR, lookupG, lookupB};
        ShortLookupTable lookupTable = new ShortLookupTable(0, array);
        LookupOp lightOp = new LookupOp(lookupTable, null);
        BufferedImage newImage = lightOp.filter(image, null);
        return newImage;
    }

    @Override
    public void resetParameters() {
        this.rSlider.setValue(0);
        this.gSlider.setValue(0);
        this.bSlider.setValue(0);
    }
}

