/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.dialogs;

import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import java.util.Collections;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import tecgraf.javautils.core.lng.LNG;

class ProjectListTableModel
extends DefaultTableModel {
    private static String[] COL_NAMES = new String[]{LNG.get((String)"ProjectListTableModel.header.user"), LNG.get((String)"ProjectListTableModel.header.project")};
    private final List<ProjectsManagerData> prjData;
    private final int numRows;

    public ProjectListTableModel(List<ProjectsManagerData> projectsRW) {
        this.prjData = Collections.unmodifiableList(projectsRW);
        this.numRows = this.prjData.size();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return COL_NAMES.length;
    }

    @Override
    public String getColumnName(int col) {
        return COL_NAMES[col];
    }

    @Override
    public int getRowCount() {
        return this.numRows;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.prjData.get(row).getOwnerName();
        }
        return this.prjData.get(row).getProjectName();
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    public ProjectsManagerData getProject(int row) {
        return this.prjData.get(row);
    }
}

