/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.serverdiagnostic.statistics;

import csbase.client.applications.ApplicationComponentPanel;
import csbase.client.applications.serverdiagnostic.ServerDiagnostic;
import csbase.client.applications.serverdiagnostic.statistics.FilterItem;
import csbase.client.applications.serverdiagnostic.statistics.StatisticDataEntry;
import csbase.client.applications.serverdiagnostic.statistics.StatisticalTable;
import csbase.logic.CommandFinalizationType;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.diagnosticservice.ServerStatisticsInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import tecgraf.javautils.gui.GBC;

public class ServerStatisticsPanel
extends ApplicationComponentPanel<ServerDiagnostic> {
    private ServerStatisticsInfo serverStatisticsInfo;
    private StatisticalTable<StatisticDataEntry<Integer>> loginStatisticalTable;
    private StatisticalTable<StatisticDataEntry<Integer>> executionTypeCommandStatisticalTable;
    private StatisticalTable<StatisticDataEntry<Integer>> algorithmCommandStatisticalTable;
    private StatisticalTable<StatisticDataEntry<Integer>> userCommandStatisticalTable;
    private StatisticalTable<StatisticDataEntry<Integer>> machineCommandStatisticalTable;
    private StatisticalTable<StatisticDataEntry<Integer>> resultCommandStatisticalTable;
    JSplitPane mainPanel;
    JList categotyList;

    public ServerStatisticsPanel(ServerDiagnostic application, ServerStatisticsInfo serverStatisticsInfo) {
        super(application);
        this.serverStatisticsInfo = serverStatisticsInfo;
        this.loginStatisticalTable = new StatisticalTable(this.getString("login.table.entity.column.name"), this.getString("login.table.value.column.name"));
        this.executionTypeCommandStatisticalTable = new StatisticalTable(this.getString("execution.type.table.entity.column.name"), this.getString("execution.type.table.value.column.name"));
        this.algorithmCommandStatisticalTable = new StatisticalTable(this.getString("algorithm.table.entity.column.name"), this.getString("algorithm.table.value.column.name"));
        this.userCommandStatisticalTable = new StatisticalTable(this.getString("user.table.entity.column.name"), this.getString("user.table.value.column.name"));
        this.machineCommandStatisticalTable = new StatisticalTable(this.getString("machine.table.entity.column.name"), this.getString("machine.table.value.column.name"));
        this.resultCommandStatisticalTable = new StatisticalTable(this.getString("result.table.entity.column.name"), this.getString("result.table.value.column.name"));
        this.buildInterface();
    }

    private void buildInterface() {
        JPanel listPanel = this.buildCategoryListPanel();
        JPanel contentPanel = new JPanel();
        this.mainPanel = new JSplitPane(1, listPanel, contentPanel);
        this.mainPanel.setOneTouchExpandable(true);
        this.mainPanel.setDividerLocation(200);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.mainPanel, new GBC(0, 0).both().insets(5, 5, 5, 5));
        this.categotyList.setSelectedIndex(0);
    }

    private JPanel buildCategoryListPanel() {
        DefaultListModel<String> categoryListModel = new DefaultListModel<String>();
        categoryListModel.addElement(this.getString("login.category"));
        categoryListModel.addElement(this.getString("command.execution.category"));
        this.categotyList = new JList(categoryListModel);
        this.categotyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    if (((JList)event.getSource()).getSelectedValue().equals(ServerStatisticsPanel.this.getString("login.category"))) {
                        ServerStatisticsPanel.this.mainPanel.setRightComponent(ServerStatisticsPanel.this.buildUserStatisticsPanel());
                    } else if (((JList)event.getSource()).getSelectedValue().equals(ServerStatisticsPanel.this.getString("command.execution.category"))) {
                        ServerStatisticsPanel.this.mainPanel.setRightComponent(ServerStatisticsPanel.this.buildCommandExecutionStatisticsPanel());
                    }
                    ServerStatisticsPanel.this.mainPanel.setDividerLocation(ServerStatisticsPanel.this.mainPanel.getDividerLocation());
                }
            }
        });
        JPanel categoryListPanel = new JPanel();
        categoryListPanel.setLayout(new GridBagLayout());
        categoryListPanel.add((Component)new JScrollPane(this.categotyList), new GBC(0, 0).insets(0, 0, 0, 5).both());
        return categoryListPanel;
    }

    private JPanel buildUserStatisticsPanel() {
        JPanel userStatsPanel = new JPanel();
        userStatsPanel.setLayout(new GridBagLayout());
        userStatsPanel.add((Component)this.buildTimeStampPanel(), new GBC(0, 0).insets(0, 5, 5, 0).horizontal().northwest().gridwidth(2));
        JLabel connectedUserLabel = new JLabel(MessageFormat.format(this.getString("connected.users.label"), this.serverStatisticsInfo.usersStatisticsInfo.connectedUsers.length, this.serverStatisticsInfo.usersStatisticsInfo.numRegisteredUsers));
        userStatsPanel.add((Component)connectedUserLabel, new GBC(0, 1).insets(5, 5, 5, 0).northwest().gridwidth(2));
        JLabel loginTryNumberLabel = new JLabel(MessageFormat.format(this.getString("login.try.number.label"), this.countLogin(this.serverStatisticsInfo.loginStatisticsInfo.succeededLogins) + this.countLogin(this.serverStatisticsInfo.loginStatisticsInfo.failedLogins)));
        userStatsPanel.add((Component)loginTryNumberLabel, new GBC(0, 2).insets(5, 5, 5, 0).northwest().gridwidth(2));
        JLabel succeededLoginLabel = new JLabel(MessageFormat.format(this.getString("succeeded.login.number.label"), this.countLogin(this.serverStatisticsInfo.loginStatisticsInfo.succeededLogins)));
        userStatsPanel.add((Component)succeededLoginLabel, new GBC(0, 3).insets(5, 5, 5, 5).northwest());
        JLabel faledLoginLabel = new JLabel(MessageFormat.format(this.getString("faled.login.label"), this.countLogin(this.serverStatisticsInfo.loginStatisticsInfo.failedLogins)));
        userStatsPanel.add((Component)faledLoginLabel, new GBC(1, 3).insets(5, 5, 5, 0).northwest());
        userStatsPanel.add((Component)new JScrollPane(this.buildLoginStatsTable(this.serverStatisticsInfo.loginStatisticsInfo.succeededLogins)), new GBC(0, 4).insets(5, 5, 0, 5).both().weightx(0.5));
        userStatsPanel.add((Component)new JScrollPane(this.buildLoginStatsTable(this.serverStatisticsInfo.loginStatisticsInfo.failedLogins)), new GBC(1, 4).insets(5, 5, 0, 0).both().weightx(0.5));
        return userStatsPanel;
    }

    private JPanel buildCommandExecutionStatisticsPanel() {
        final JPanel statisticsPanel = new JPanel();
        statisticsPanel.setLayout(new GridBagLayout());
        DefaultComboBoxModel<FilterItem> groupByComboBoxModel = new DefaultComboBoxModel<FilterItem>();
        groupByComboBoxModel.addElement(new FilterItem(this.getString("execution.type.filter.item.name"), this.buildExecutionTypeStatsTable(this.serverStatisticsInfo.commandExecutionStatisticsInfo.exeStats)));
        groupByComboBoxModel.addElement(new FilterItem(this.getString("algorithm.filter.item.name"), this.buildAlgorithmStatsTable(this.serverStatisticsInfo.commandExecutionStatisticsInfo.simpleAlgoExecutionStats, this.serverStatisticsInfo.commandExecutionStatisticsInfo.flowAlgoExecutionStats)));
        groupByComboBoxModel.addElement(new FilterItem(this.getString("user.filter.item.name"), this.buildUserStatsTable(this.serverStatisticsInfo.commandExecutionStatisticsInfo.userExecutionStats)));
        groupByComboBoxModel.addElement(new FilterItem(this.getString("machine.filter.item.name"), this.buildMachineStatsTable(this.serverStatisticsInfo.commandExecutionStatisticsInfo.sgasExecutionStats)));
        groupByComboBoxModel.addElement(new FilterItem(this.getString("result.filter.item.name"), this.buildResultStatsTable(this.serverStatisticsInfo.commandExecutionStatisticsInfo.simpleAlgoResultsStats, this.serverStatisticsInfo.commandExecutionStatisticsInfo.flowAlgoResultsStats)));
        JComboBox<Object> groupByComboBox = new JComboBox<Object>(groupByComboBoxModel);
        groupByComboBox.setSelectedIndex(-1);
        groupByComboBox.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object itemText = value == null ? value : ((FilterItem)value).itemName;
                return super.getListCellRendererComponent((JList<?>)list, itemText, index, isSelected, cellHasFocus);
            }
        });
        groupByComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    FilterItem selectedItem = (FilterItem)event.getItem();
                    statisticsPanel.removeAll();
                    statisticsPanel.add((Component)new JScrollPane(selectedItem.table), new GBC(0, 0).northwest().both());
                    statisticsPanel.repaint();
                    statisticsPanel.revalidate();
                }
            }
        });
        JPanel commandExecutionStatisticsPanel = new JPanel();
        commandExecutionStatisticsPanel.setLayout(new GridBagLayout());
        commandExecutionStatisticsPanel.add((Component)this.buildTimeStampPanel(), new GBC(0, 0).insets(0, 5, 5, 0).horizontal().northwest().gridwidth(2));
        int totalSubmissions = this.countTotalSubmissions(this.serverStatisticsInfo.commandExecutionStatisticsInfo.exeStats);
        commandExecutionStatisticsPanel.add((Component)new JLabel(MessageFormat.format(this.getString("total.submission.label"), totalSubmissions)), new GBC(0, 1).insets(5, 5, 5, 0).horizontal().northwest().gridwidth(2));
        commandExecutionStatisticsPanel.add((Component)new JLabel(this.getString("criteria.label")), new GBC(0, 2).insets(5, 5, 5, 5).center());
        commandExecutionStatisticsPanel.add(groupByComboBox, new GBC(1, 2).insets(5, 0, 5, 0).northwest());
        commandExecutionStatisticsPanel.add((Component)statisticsPanel, new GBC(1, 3).insets(5, 5, 0, 0).both().gridwidth(2));
        return commandExecutionStatisticsPanel;
    }

    private int countTotalSubmissions(Map<?, Integer> submissionStats) {
        int total = 0;
        for (int itemCount : submissionStats.values()) {
            total += itemCount;
        }
        return total;
    }

    private int countLogin(Map<String, Integer> loginMap) {
        int count = 0;
        for (Integer userLoginCount : loginMap.values()) {
            count += userLoginCount.intValue();
        }
        return count;
    }

    private <E> List<StatisticDataEntry<E>> convertToStatisticDataEntry(Map<String, E> data) {
        LinkedList<StatisticDataEntry<StatisticDataEntry<E>>> entryList = new LinkedList<StatisticDataEntry<StatisticDataEntry<E>>>();
        for (String login : data.keySet()) {
            entryList.add(new StatisticDataEntry<E>(login, data.get(login)));
        }
        return entryList;
    }

    private JTable buildLoginStatsTable(Map<String, Integer> data) {
        List<StatisticDataEntry<Integer>> entryList = this.convertToStatisticDataEntry(data);
        return this.loginStatisticalTable.builtTable(entryList);
    }

    private JTable buildResultStatsTable(Map<CommandFinalizationType, Integer> simpleData, Map<CommandFinalizationType, Integer> flowData) {
        HashMap<String, Integer> newSimpleData = new HashMap<String, Integer>();
        for (CommandFinalizationType finalizationType : simpleData.keySet()) {
            newSimpleData.put(finalizationType.toString(), simpleData.get(finalizationType));
        }
        List simpleEntryList = this.convertToStatisticDataEntry(newSimpleData);
        HashMap<String, Integer> newFlowData = new HashMap<String, Integer>();
        for (CommandFinalizationType finalizationType : flowData.keySet()) {
            newFlowData.put(finalizationType.toString(), flowData.get(finalizationType));
        }
        List flowEntryList = this.convertToStatisticDataEntry(newFlowData);
        simpleEntryList.addAll(flowEntryList);
        return this.resultCommandStatisticalTable.builtTable(simpleEntryList);
    }

    private JTable buildMachineStatsTable(Map<String, Integer> data) {
        List<StatisticDataEntry<Integer>> entryList = this.convertToStatisticDataEntry(data);
        return this.machineCommandStatisticalTable.builtTable(entryList);
    }

    private JTable buildUserStatsTable(Map<String, Integer> data) {
        List<StatisticDataEntry<Integer>> entryList = this.convertToStatisticDataEntry(data);
        return this.userCommandStatisticalTable.builtTable(entryList);
    }

    private JTable buildAlgorithmStatsTable(Map<String, Integer> simpleData, Map<String, Integer> flowData) {
        List<StatisticDataEntry<Integer>> simpleEntryList = this.convertToStatisticDataEntry(simpleData);
        List<StatisticDataEntry<Integer>> flowEntryList = this.convertToStatisticDataEntry(flowData);
        simpleEntryList.addAll(flowEntryList);
        return this.algorithmCommandStatisticalTable.builtTable(simpleEntryList);
    }

    private JTable buildExecutionTypeStatsTable(Map<ExecutionType, Integer> data) {
        HashMap<String, Integer> newData = new HashMap<String, Integer>();
        for (ExecutionType execType : data.keySet()) {
            newData.put(execType.toString(), data.get(execType));
        }
        List entryList = this.convertToStatisticDataEntry(newData);
        return this.executionTypeCommandStatisticalTable.builtTable(entryList);
    }

    private JPanel buildTimeStampPanel() {
        JLabel updateTimeLable = new JLabel();
        String message = "<html>" + this.getString("timestamp.message.label") + "</html>";
        Calendar startTime = Calendar.getInstance();
        startTime.setTime(this.serverStatisticsInfo.time);
        updateTimeLable.setText(MessageFormat.format(message, startTime.get(5), this.getMonth(startTime.get(2)), String.format("%02d", startTime.get(11)), String.format("%02d", startTime.get(12)), String.format("%02d", startTime.get(13))));
        JPanel timeStampPanel = new JPanel();
        timeStampPanel.setLayout(new GridBagLayout());
        timeStampPanel.add((Component)updateTimeLable, new GBC(0, 0).insets(0, 0, 20, 0).both().northwest());
        timeStampPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK));
        return timeStampPanel;
    }

    private String getMonth(int month) {
        Locale locale = this.getLocale();
        if (locale != null) {
            locale = ServerStatisticsPanel.getDefaultLocale();
        }
        return DateFormatSymbols.getInstance(locale).getMonths()[month];
    }
}

