/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v2.extras.openbus;

import csbase.client.csdk.v2.core.CSDKAbstractContext;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.logic.BusInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.OpenBusServiceInterface;
import csdk.v2.extras.context.IOpenBusContext;
import csdk.v2.extras.context.exception.InitializationException;
import java.rmi.RemoteException;
import java.util.Properties;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.assistant.Assistant;
import tecgraf.openbus.assistant.AssistantParams;
import tecgraf.openbus.core.ORBInitializer;

public class CSDKOpenBusContext
extends CSDKAbstractContext
implements IOpenBusContext {
    private Assistant assistant = null;

    public Assistant getAssistant(AssistantParams params) throws InitializationException {
        if (this.assistant == null) {
            try {
                OpenBusServiceInterface openBusService = ClientRemoteLocator.openBusService;
                if (openBusService == null) {
                    String err = this.getString("openbus.service.null.error");
                    throw new InitializationException(err);
                }
                BusInfo busInfo = openBusService.getBusInfo();
                String host = busInfo.getHost();
                int port = busInfo.getPort();
                String password = ClientRemoteMonitor.getInstance().getLoginInfo().getPassword();
                String user = ClientRemoteMonitor.getInstance().getLoginInfo().getLoginName();
                if (params != null) {
                    Properties orbProperties = new Properties();
                    orbProperties.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
                    params.orb = ORBInitializer.initORB(null, (Properties)orbProperties);
                    this.assistant = Assistant.createWithPassword((String)host, (int)port, (String)user, (byte[])password.getBytes(), (AssistantParams)params);
                } else {
                    this.assistant = Assistant.createWithPassword((String)host, (int)port, (String)user, (byte[])password.getBytes());
                }
            }
            catch (RemoteException e) {
                String err = this.getString("openbus.service.null.error");
                throw new InitializationException(err);
            }
        }
        return this.assistant;
    }

    private String getString(String key) {
        String prefix = this.getClass().getSimpleName();
        return LNG.get((String)(prefix + "." + key));
    }

    @Override
    protected void contextDeactivated() {
        try {
            this.assistant.shutdown();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.assistant.orb().shutdown(false);
            }
            catch (Exception exception) {}
        }
    }
}

