/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.actions;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.commandsmonitor.CommandsMonitor;
import csbase.client.applications.commandsmonitor.actions.AbstractCommandsAction;
import csbase.client.applications.executor.ExecutorFrame;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.CommonClientProject;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Set;

public class ExecuteCommandAction
extends AbstractCommandsAction {
    public ExecuteCommandAction(CommandsMonitor application) {
        super(application, false, ApplicationImages.ICON_EXECUTE_CMD_16);
    }

    @Override
    protected boolean accept(CommandInfo command) {
        return command.getStatus() != CommandStatus.SCHEDULED && command.getStatus() != CommandStatus.SYSTEM_FAILURE;
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        CommandInfo command = this.getSelectedCommand();
        this.executeCommand(command);
    }

    private boolean executeCommand(final CommandInfo command) throws ApplicationException, ParameterNotFoundException {
        CommonClientProject project = DesktopFrame.getInstance().getProject();
        if (null == project) {
            ApplicationFrame frame = ((CommandsMonitor)this.getApplication()).getApplicationFrame();
            String msg = this.getString("ExecuteCommandAction.project.missing.error", new Object[0]);
            StandardErrorDialogs.showErrorDialog((Window)frame, frame.getTitle(), msg);
            return false;
        }
        if (!project.isWritable()) {
            ApplicationFrame frame = ((CommandsMonitor)this.getApplication()).getApplicationFrame();
            String msg = this.getString("ExecuteCommandAction.executing.permission.error", project.getName());
            StandardErrorDialogs.showErrorDialog((Window)frame, frame.getTitle(), msg);
            return false;
        }
        RemoteTask<AlgorithmConfigurator> task = new RemoteTask<AlgorithmConfigurator>(){

            public void performTask() throws Exception {
                AlgorithmConfigurator configurator = command.getConfigurator();
                this.setResult(configurator);
            }
        };
        String title = ((CommandsMonitor)this.getApplication()).getString("task.command.retrieve.title");
        String msg = ((CommandsMonitor)this.getApplication()).getString("task.command.retrieve.message");
        if (!task.execute(((CommandsMonitor)this.getApplication()).getApplicationFrame(), title, msg)) {
            return false;
        }
        AlgorithmConfigurator configurator = (AlgorithmConfigurator)task.getResult();
        if (null == configurator) {
            String error = ((CommandsMonitor)this.getApplication()).getString("task.command.retrieve.error");
            ((CommandsMonitor)this.getApplication()).showError(error);
            return false;
        }
        if (null == configurator.getAlgorithmName() && null == configurator.getAlgorithmVersionId() && configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW) {
            ApplicationManager applicationManager = ApplicationManager.getInstance();
            FlowApplication application = applicationManager.runApplication(FlowApplication.class);
            return application.editConfigurator((FlowAlgorithmConfigurator)configurator, command.getDescription());
        }
        String algName = configurator.getAlgorithmName();
        AlgorithmVersionId algVersionId = configurator.getAlgorithmVersionId();
        HashMap<String, String> parameters = new HashMap<String, String>();
        Set names = configurator.getParameterNames();
        for (String name : names) {
            String value = configurator.getParameterValue(name);
            parameters.put(name, value);
        }
        ExecutorFrame executorFrame = (ExecutorFrame)ApplicationManager.getInstance().runApplication("executor");
        executorFrame.showConfigurator(algName, algVersionId, parameters);
        return true;
    }
}

