/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.fileexchanger.logic;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.FileExchangerUI;
import csbase.client.util.AnimatedIcon;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public enum ExchangeState {
    CREATED,
    QUEUED,
    RUNNING(true),
    FINISHED,
    INTERRUPTED,
    PAUSED,
    ERROR,
    REMOVED;

    private boolean hasAnimatedIcon;

    private ExchangeState() {
        this(false);
    }

    private ExchangeState(boolean hasAnimatedIcon) {
        this.hasAnimatedIcon = hasAnimatedIcon;
    }

    public String getDescription() {
        String className = ((Object)((Object)this)).getClass().getSimpleName();
        String tag = String.format("%s.%s.description", className, this.toString());
        return FileExchangerUI.getString(tag);
    }

    public Icon getImage() {
        String prefixTag = this.getPrefixTag();
        String path = String.format("states/%s.16.gif", prefixTag);
        ImageIcon imageIcon = FileExchanger.getImageIcon(FileExchanger.class, path);
        if (imageIcon != null) {
            if (this.isAnimated()) {
                return new AnimatedIcon(imageIcon);
            }
            return imageIcon;
        }
        return null;
    }

    private String getPrefixTag() {
        String className = ((Object)((Object)this)).getClass().getSimpleName();
        String prefixTag = String.format("%s.%s", className, this.toString());
        return prefixTag;
    }

    private boolean isAnimated() {
        return this.hasAnimatedIcon;
    }
}

