/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.multiflow;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationComponentDialog;
import csbase.logic.ClientFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;

public abstract class AbstractMultipleFlowConfigurationDialog
extends ApplicationComponentDialog<Application> {
    protected static final String CONFIGURATION_FILE_TYPE = "MFLX";
    private boolean confirmed;
    protected ClientFile configurationFile;

    public AbstractMultipleFlowConfigurationDialog(Application application, ClientFile configFile) {
        super(application);
        this.configurationFile = configFile;
        this.setConfirmed(false);
    }

    public AbstractMultipleFlowConfigurationDialog(Application application) {
        this(application, (ClientFile)null);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.createUI();
            this.setTitle(this.getClassString("windowTitle"));
        }
        super.setVisible(visible);
    }

    protected void createUI() {
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        JComponent contentPanel = this.createMainComponent();
        this.add((Component)contentPanel, "Center");
        JPanel buttonPanel = this.createButtonPanel();
        this.add((Component)buttonPanel, "South");
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.validate();
    }

    protected abstract JComponent createMainComponent();

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GBC gbc = new GBC().weighty(1.0);
        JButton okButton = new JButton(this.getClassString("okButton"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AbstractMultipleFlowConfigurationDialog.this.validateFields()) {
                    AbstractMultipleFlowConfigurationDialog.this.setConfirmed(true);
                    AbstractMultipleFlowConfigurationDialog.this.setVisible(false);
                } else {
                    AbstractMultipleFlowConfigurationDialog.this.setConfirmed(false);
                }
            }
        });
        buttonPanel.add((Component)okButton, gbc);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton(this.getClassString("cancelButton"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractMultipleFlowConfigurationDialog.this.setConfirmed(false);
                AbstractMultipleFlowConfigurationDialog.this.setVisible(false);
            }
        });
        buttonPanel.add((Component)cancelButton, new GBC(gbc).gridx(1).east());
        return buttonPanel;
    }

    protected boolean validateFields() {
        return this.validateFile();
    }

    protected boolean validateFile() {
        if (this.configurationFile == null) {
            ((Application)this.getApplication()).showError(this.getClassString("fileNotSelectedError"));
            return false;
        }
        return true;
    }

    public ClientFile getConfigurationFile() {
        if (this.isConfirmed()) {
            return this.configurationFile;
        }
        return null;
    }

    protected boolean isConfirmed() {
        return this.confirmed;
    }

    protected void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    protected void setConfigurationFile(ClientFile configurationFile) {
        this.configurationFile = configurationFile;
    }
}

