/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.util.gui.ComponentUtilities;
import csbase.logic.UserInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

public abstract class UserInfoDialog {
    protected DesktopComponentDialog userInfoDialog;
    protected Window ownerWindow;
    protected JTextField name;
    protected JTextField login;
    protected DefaultListModel emailsModel;
    protected JTextField addEmailTf;
    protected String dialogTitle;
    protected UserInfo userInfo;

    protected UserInfoDialog(Window ownerWindow, String dialogTitle) {
        this.ownerWindow = ownerWindow;
        this.dialogTitle = dialogTitle;
        this.userInfo = new UserInfo(null, null, new String[0], new Object[0], new Object[0]);
    }

    public void setVisible(boolean b) {
        if (this.userInfoDialog == null) {
            this.makeDialog();
            this.addDataComponentsListeners();
        }
        this.userInfoDialog.setVisible(b);
    }

    protected void addDataComponentsListeners() {
        DocumentListener docListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                UserInfoDialog.this.fireOnDataChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                UserInfoDialog.this.fireOnDataChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                UserInfoDialog.this.fireOnDataChanged();
            }
        };
        this.login.getDocument().addDocumentListener(docListener);
        this.name.getDocument().addDocumentListener(docListener);
        this.emailsModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                UserInfoDialog.this.fireOnDataChanged();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                UserInfoDialog.this.fireOnDataChanged();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                UserInfoDialog.this.fireOnDataChanged();
            }
        });
    }

    protected void makeDialog() {
        this.userInfoDialog = new DesktopComponentDialog(this.ownerWindow, this.dialogTitle);
        JPanel userInfoPanel = new JPanel(new BorderLayout());
        userInfoPanel.setBorder(BorderFactory.createTitledBorder(LNG.get((String)"IAS_USER_REGISTRATION")));
        userInfoPanel.add((Component)this.makeUpperPanel(), "North");
        userInfoPanel.add((Component)this.makeMiddlePanel(), "South");
        Container contentPane = this.userInfoDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)userInfoPanel, "Center");
        contentPane.add((Component)this.makeLowerPanel(), "South");
        this.userInfoDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UserInfoDialog.this.close();
            }
        });
        this.userInfoDialog.pack();
        this.userInfoDialog.center(this.ownerWindow);
    }

    public DesktopComponentDialog getUserInfoDialog() {
        return this.userInfoDialog;
    }

    protected List<JComponent[]> createDataComponents() {
        this.login = this.getLogin();
        this.name = new JTextField(20);
        this.emailsModel = new DefaultListModel();
        this.addEmailTf = new JTextField(20);
        JButton addEmailBtn = new JButton();
        final JList emails = new JList(this.emailsModel);
        final JButton removeEmailBtn = new JButton();
        this.addEmailTf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserInfoDialog.this.addEmail();
            }
        });
        final AbstractAction addEmailAction = new AbstractAction(LNG.get((String)"IAS_USER_EMAIL_ADD_BUTTON")){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserInfoDialog.this.addEmail();
            }
        };
        addEmailAction.setEnabled(!this.addEmailTf.getText().trim().isEmpty());
        this.addEmailTf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                addEmailAction.setEnabled(!UserInfoDialog.this.addEmailTf.getText().trim().isEmpty());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                addEmailAction.setEnabled(!UserInfoDialog.this.addEmailTf.getText().trim().isEmpty());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                addEmailAction.setEnabled(true);
            }
        });
        addEmailBtn.setAction(addEmailAction);
        final AbstractAction removeEmailAction = new AbstractAction(LNG.get((String)"IAS_USER_EMAIL_REMOVE_BUTTON")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = emails.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                UserInfoDialog.this.emailsModel.remove(index);
                if (UserInfoDialog.this.emailsModel.getSize() > 0) {
                    if (index == UserInfoDialog.this.emailsModel.getSize()) {
                        --index;
                    }
                    emails.setSelectedIndex(index);
                    emails.ensureIndexIsVisible(index);
                }
            }
        };
        removeEmailAction.setEnabled(emails.getSelectedIndex() >= 0);
        emails.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                removeEmailAction.setEnabled(emails.getSelectedIndex() >= 0);
            }
        });
        removeEmailBtn.setAction(removeEmailAction);
        emails.setSelectionMode(1);
        emails.setVisibleRowCount(4);
        emails.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                removeEmailBtn.setEnabled(emails.getSelectedIndex() >= 0);
            }
        });
        JScrollPane scrollableEmails = new JScrollPane(emails);
        ComponentUtilities.setMaxPreferredWidth(this.addEmailTf, scrollableEmails);
        ComponentUtilities.setMaxPreferredWidth(addEmailBtn, removeEmailBtn);
        JPanel emailPanel = new JPanel(new GridBagLayout());
        GBC gbc = new GBC(0, 0).northwest().horizontal().insets(0, 0, 5, 5);
        emailPanel.add((Component)this.addEmailTf, gbc);
        gbc.gridx(1).northeast().none().insets(0, 0, 5, 0);
        emailPanel.add((Component)addEmailBtn, gbc);
        gbc.gridx(0).gridy(1).northwest().horizontal().insets(0, 0, 0, 5);
        emailPanel.add((Component)scrollableEmails, gbc);
        gbc.gridx(1).northeast().none().insets(0, 0, 0, 0);
        emailPanel.add((Component)removeEmailBtn, gbc);
        ArrayList<JComponent[]> components = new ArrayList<JComponent[]>();
        components.add(new JComponent[]{new JLabel(LNG.get((String)"IAS_USER")), this.login});
        components.add(new JComponent[]{new JLabel(LNG.get((String)"IAS_USER_NAME")), this.name});
        components.add(new JComponent[]{new JLabel(LNG.get((String)"IAS_USER_EMAIL")), emailPanel});
        return components;
    }

    public void addEmail() {
        if (!this.addEmailTf.getText().isEmpty()) {
            this.emailsModel.addElement(this.addEmailTf.getText());
            this.addEmailTf.setText(null);
        }
    }

    protected JPanel makeUpperPanel() {
        List<JComponent[]> components = this.createDataComponents();
        int T = 12;
        int TI = 6;
        int L = 11;
        int B = 12;
        int R = 11;
        JPanel upperPanel = new JPanel(new GridBagLayout());
        for (int inx = 0; inx < components.size(); ++inx) {
            JComponent label = components.get(inx)[0];
            JComponent component = components.get(inx)[1];
            GBC gbc = new GBC(0, inx);
            gbc = gbc.gridheight(1).gridwidth(1);
            gbc = gbc.west().weights(1.0, 0.0);
            gbc = components.size() == 1 ? gbc.insets(12, 11, 12, 11) : (inx == 0 ? gbc.insets(12, 11, 0, 11) : (inx == components.size() - 1 ? gbc.insets(6, 11, 12, 11) : gbc.insets(6, 11, 0, 11)));
            gbc = gbc.none().northwest();
            upperPanel.add((Component)label, gbc);
            gbc = gbc.gridx(1).horizontal().weightx(100.0);
            upperPanel.add((Component)component, gbc);
        }
        return upperPanel;
    }

    protected JPanel makeMiddlePanel() {
        return new JPanel();
    }

    protected JButton makeCloseButton() {
        JButton button = new JButton(LNG.get((String)"IAS_CLOSE"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                UserInfoDialog.this.close();
            }
        });
        return button;
    }

    private void close() {
        if (this.unsavedDataInput() && !this.confirmClose()) {
            return;
        }
        this.userInfoDialog.close();
    }

    protected boolean requiredFieldsAreFilled() {
        return !this.login.getText().trim().isEmpty() && !this.name.getText().trim().isEmpty();
    }

    protected void updateUserInfo() {
        String nameText = this.name.getText().trim();
        String loginText = this.login.getText().trim();
        String[] emails = new String[this.emailsModel.getSize()];
        for (int inx = 0; inx < emails.length; ++inx) {
            emails[inx] = this.emailsModel.getElementAt(inx).toString().trim();
        }
        this.userInfo.setAttribute("name", (Object)nameText);
        this.userInfo.setAttribute("login", (Object)loginText);
        this.userInfo.setAttribute("emails", (Object)emails);
    }

    protected JPanel makeLowerPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.makeCloseButton());
        return buttonPanel;
    }

    protected JTextField getLogin() {
        if (this.login == null) {
            this.login = new JTextField(20);
        }
        return this.login;
    }

    protected void fireOnDataChanged() {
    }

    protected abstract boolean unsavedDataInput();

    protected abstract boolean confirmClose();
}

