/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.Client;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.ProjectTree;
import csbase.client.project.action.CommonProjectAction;
import csbase.client.project.tasks.ChangeFileTypeTask;
import csbase.logic.ClientFile;
import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileType;
import csbase.logic.filetypefinder.FileTypeFinder;
import java.awt.event.ActionEvent;
import tecgraf.javautils.core.lng.LNG;

public class CommonFileTypeInferAction
extends CommonProjectAction {
    public CommonFileTypeInferAction(ProjectFileContainer container) {
        super(container);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DesktopFrame desktop = DesktopFrame.getInstance();
        ProjectTree projTree = desktop.getTree();
        FileTypeFinder fileTypeFinder = projTree.getFileTypeFinder();
        if (fileTypeFinder == null) {
            return;
        }
        ClientProjectFile file = this.getSelectedFile();
        ProjectFileType type = fileTypeFinder.inferType((ClientFile)file, Client.getInstance().getSystemDefaultCharset());
        if (type == null) {
            return;
        }
        DesktopComponentFrame dskFrame = desktop.getDesktopFrame();
        ChangeFileTypeTask.runTask(dskFrame, file, type);
    }

    @Override
    public String getName() {
        return LNG.get((String)"PRJ_INFER_TYPE");
    }
}

