/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.rest;

import csbase.client.Client;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.NotificationPanel;
import csbase.client.desktop.RemoteTask;
import csbase.client.login.LoginInterface;
import csbase.client.login.PreLogin;
import csbase.client.rest.AuthFilter;
import csbase.client.rest.DebugMapper;
import csbase.client.rest.ReloadFilter;
import csbase.logic.SecureKey;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.RestServiceInterface;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import io.swagger.jersey.listing.ApiListingResourceJSON;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.URI;
import java.rmi.RemoteException;
import java.security.DigestException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Configuration;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import tecgraf.javautils.core.lng.LNG;

public class RestController {
    private static RestController instance;
    private ResourceConfig resourceConfig;
    private HttpServer httpServer;
    private Container container;
    private String token;
    private final LoginInterface userLogin = Client.getInstance().getLoginObject();
    private boolean developMode = false;
    private final List<String> resourcePackages = new ArrayList<String>();
    private final Map<String, Set<Object>> instancesByPrefix;
    private final Map<Class<?>, String> prefixByResourceClass;
    private String docFrontEndDirectory;
    private BeanConfig beanConfig;
    private boolean shouldReload;
    private int httpPort;
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 15000;

    public void setDocFrontEndDirectory(String docFrontEndDirectory) {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            throw new IllegalStateException("Server is already started");
        }
        this.docFrontEndDirectory = docFrontEndDirectory;
    }

    public static RestController getInstance() {
        if (instance == null) {
            instance = new RestController();
        }
        return instance;
    }

    private static int getAvailablePort() {
        int port;
        block11: {
            ServerSocket socket = null;
            port = -1;
            try {
                socket = new ServerSocket(0);
                port = socket.getLocalPort();
            }
            catch (IOException e) {
                if (socket == null) break block11;
                try {
                    socket.close();
                }
                catch (IOException e2) {
                    throw new RuntimeException("You should handle this error.", e2);
                }
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("You should handle this error.", e);
                    }
                }
            }
        }
        return port;
    }

    private RestController() {
        this.resourcePackages.add("csbase.client.rest.resources");
        this.instancesByPrefix = new HashMap<String, Set<Object>>();
        this.prefixByResourceClass = new HashMap();
        this.docFrontEndDirectory = "csbase/client/rest/swagger-ui/";
        if (this.userLogin instanceof PreLogin) {
            this.token = ((PreLogin)this.userLogin).getClientInstanceId();
            if (this.token.startsWith("TOKENID:")) {
                this.token = this.token.substring("TOKENID:".length());
            }
        } else {
            SecureKey sessionKey = new SecureKey();
            try {
                this.token = sessionKey.digest();
            }
            catch (DigestException e) {
                e.printStackTrace();
                this.token = this.userLogin.getClientInstanceId();
            }
        }
    }

    public String getAuthToken() {
        return this.token;
    }

    public boolean isDeveloperMode() {
        return this.developMode;
    }

    public boolean isTokenAuthorized(String checkToken) {
        return this.isDeveloperMode() || this.token.equals(checkToken);
    }

    public LoginInterface getUserLogin() {
        return this.userLogin;
    }

    public void stopServer() {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            this.httpServer.shutdownNow();
            RemoteTask<Void> task = new RemoteTask<Void>(){

                protected void performTask() throws Exception {
                    ClientRemoteLocator.restService.unregisterClientHttpServer(RestController.this.token);
                }
            };
            String msg = LNG.get((String)"csbase.client.rest.server.unregistering");
            task.execute(DesktopFrame.getInstance().getDesktopFrame(), null, msg);
            if (task.getError() != null) {
                task.getError().printStackTrace();
            }
        }
    }

    public void startServer() {
        try {
            this.startServer(DEFAULT_HOST, 15000);
        }
        catch (ProcessingException ex) {
            int availablePort = RestController.getAvailablePort();
            this.startServer(DEFAULT_HOST, availablePort);
        }
    }

    public void startServer(int port) {
        this.startServer(DEFAULT_HOST, port);
    }

    public void startServer(String host, int port) {
        this.httpPort = port;
        try {
            this.beanConfig = new BeanConfig();
            this.beanConfig.setVersion("1.0");
            this.beanConfig.setDescription(LNG.get((String)"csbase.client.rest.server.description"));
            this.beanConfig.setBasePath("/");
            this.beanConfig.setResourcePackage(String.join((CharSequence)",", this.resourcePackages));
            this.beanConfig.setScan(true);
            this.resourceConfig = this.buildResourceConfig();
            this.resourceConfig.registerInstances(new Object[]{new ContainerLifecycleListener(){

                public void onStartup(Container cont) {
                    RestController.this.container = cont;
                }

                public void onReload(Container cont) {
                }

                public void onShutdown(Container cont) {
                }
            }});
            final String baseURL = "http://" + host + ":" + port + "/";
            this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)URI.create(baseURL), (ResourceConfig)this.resourceConfig);
            CLStaticHttpHandler staticHttpHandler = new CLStaticHttpHandler(RestController.class.getClassLoader(), new String[]{this.docFrontEndDirectory});
            this.httpServer.getServerConfiguration().addHttpHandler((HttpHandler)staticHttpHandler, new String[]{"/docs/"});
            RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

                protected void performTask() throws Exception {
                    RestServiceInterface restService = ClientRemoteLocator.restService;
                    restService.registerClientHttpServer(RestController.this.token, baseURL);
                    boolean devMode = restService.isClientDeveloperMode();
                    this.setResult(devMode);
                }
            };
            String taskMsg = LNG.get((String)"csbase.client.rest.server.registering");
            task.execute(DesktopFrame.getInstance().getDesktopFrame(), null, taskMsg);
            Exception error = task.getError();
            if (error == null) {
                this.developMode = (Boolean)task.getResult();
            } else {
                String errorMsg = LNG.get((String)"csbase.client.rest.server.start.error") + " - " + error.getLocalizedMessage();
                this.addNotificationMessage(errorMsg);
            }
            String logMsg = LNG.get((String)"csbase.client.rest.server.started") + " - " + port + (this.isDeveloperMode() ? " (dev mode)" : "");
            this.addNotificationMessage(logMsg);
            String apiMsg = LNG.get((String)"csbase.client.rest.server.doc.notification") + " " + baseURL + "docs/";
            this.addNotificationMessage(apiMsg);
            this.logMessage("RestService", "Sevidor iniciado na porta " + port);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            if (ex instanceof ProcessingException) {
                throw ex;
            }
            String apiMsg = LNG.get((String)"csbase.client.rest.server.error") + " " + ex.getLocalizedMessage();
            this.addNotificationMessage(apiMsg);
        }
    }

    private void addNotificationMessage(String msg) {
        NotificationPanel notificationPanel = DesktopFrame.getInstance().getNotificationPanel();
        notificationPanel.addNotificationLine(notificationPanel.makeNotificationLine(new Date(), "ClientRestService", msg, true));
    }

    public void registerService(Class<?>[] classes) {
        this.resourceConfig.registerClasses((Class[])classes);
    }

    public void addResourcePackages(String ... packages) {
        this.resourcePackages.addAll(Arrays.asList(packages));
        this.beanConfig.setResourcePackage(String.join((CharSequence)",", this.resourcePackages));
        this.beanConfig.setScan(true);
        if (this.container != null) {
            this.resourceConfig = this.buildResourceConfig();
            this.container.reload(this.resourceConfig);
        }
    }

    public void addApplicationResources(String prefix, ResourceConfig config) {
        Set instances = config.getInstances();
        for (Object i : instances) {
            this.prefixByResourceClass.put(i.getClass(), prefix);
        }
        this.instancesByPrefix.put(prefix, instances);
        this.shouldReload = true;
        this.reloadContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadContainer() {
        ReloadFilter.RequestCounter counter = ReloadFilter.getCounter();
        Object object = counter.getLock();
        synchronized (object) {
            if (this.shouldReload) {
                if (counter.isZero()) {
                    if (this.container != null) {
                        this.resourceConfig = this.buildResourceConfig();
                        this.container.reload(this.resourceConfig);
                    }
                    this.shouldReload = false;
                } else {
                    TimerTask timerTask = new TimerTask(){

                        @Override
                        public void run() {
                            RestController.this.reloadContainer();
                        }
                    };
                    Timer timer = new Timer("RestController reload timer");
                    timer.schedule(timerTask, 300L);
                }
            }
        }
    }

    public void removeApplicationResources(String prefix) {
        this.instancesByPrefix.remove(prefix);
        this.prefixByResourceClass.entrySet().removeIf(entry -> ((String)entry.getValue()).equals(prefix));
        this.shouldReload = true;
        this.reloadContainer();
    }

    public int getPort() {
        if (this.httpServer == null || !this.httpServer.isStarted()) {
            return -999;
        }
        return this.httpPort;
    }

    public void registerPackages(String ... packages) {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            this.httpServer.shutdownNow();
        }
        this.resourcePackages.addAll(Arrays.asList(packages));
        this.startServer();
    }

    private void logMessage(String type, String msg) {
        try {
            ClientRemoteLocator.eventLogService.addClientInformation(new String[]{"ClientRest"}, new String[]{type, msg});
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private ResourceConfig buildResourceConfig() {
        ResourceConfig rc = new ResourceConfig();
        rc.register(ApplicationApiModelProcessor.class);
        rc.packages(true, this.resourcePackages.toArray(new String[this.resourcePackages.size()]));
        this.instancesByPrefix.entrySet().forEach(e -> rc.registerInstances(((Set)e.getValue()).toArray()));
        rc.register(JacksonFeature.class);
        rc.register(AuthFilter.class);
        rc.register(DebugMapper.class);
        rc.register(ReloadFilter.class);
        rc.register(ApiListingResourceJSON.class);
        rc.register(ApiListingResource.class);
        rc.register(SwaggerSerializers.class);
        return rc;
    }

    public static class ApplicationApiModelProcessor
    implements ModelProcessor {
        public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
            ResourceModel.Builder newModelBuilder = new ResourceModel.Builder(false);
            for (Resource res : resourceModel.getResources()) {
                boolean isAppResource = false;
                for (Map.Entry prefixByClass : RestController.getInstance().prefixByResourceClass.entrySet()) {
                    if (!res.getHandlerClasses().contains(prefixByClass.getKey())) continue;
                    isAppResource = true;
                    Resource newRes = this.createResource(res, (String)prefixByClass.getValue(), (Class)prefixByClass.getKey(), true);
                    newModelBuilder.addResource(newRes);
                }
                if (isAppResource) continue;
                newModelBuilder.addResource(res);
            }
            return newModelBuilder.build();
        }

        private Resource createResource(Resource resource, String prefix, Class<?> clazz, boolean isParentResource) {
            Resource.Builder resourceBuilder = Resource.builder().name(resource.getName());
            if (isParentResource) {
                resourceBuilder.path("/" + prefix + resource.getPath());
            } else {
                resourceBuilder.path(resource.getPath());
            }
            resource.getChildResources().forEach(r -> resourceBuilder.addChildResource(this.createResource((Resource)r, prefix, clazz, false)));
            for (ResourceMethod resourceMethod : resource.getResourceMethods()) {
                Method classMethod = this.getClassMethod(resourceMethod);
                if (!classMethod.getDeclaringClass().equals(clazz)) continue;
                resourceBuilder.addMethod(resourceMethod);
            }
            return resourceBuilder.build();
        }

        private Method getClassMethod(ResourceMethod resourceMethod) {
            return resourceMethod.getInvocable().getDefinitionMethod();
        }

        public ResourceModel processSubResource(ResourceModel resourceModel, Configuration configuration) {
            return resourceModel;
        }
    }
}

